/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.EventListener;
import org.eclipse.jetty.annotations.AnnotationFinder;
import org.eclipse.jetty.annotations.AnnotationProcessor;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;

public class Configuration
extends org.eclipse.jetty.plus.webapp.Configuration {
    public static final String __web_inf_pattern = "org.eclipse.jetty.server.webapp.WebInfIncludeAnnotationJarPattern";
    public static final String __container_pattern = "org.eclipse.jetty.server.webapp.ContainerIncludeAnnotationJarPattern";

    public void parseAnnotations() throws Exception {
        AnnotationFinder finder = new AnnotationFinder();
        Log.debug((String)"Scanning system jars");
        finder.find(this.getWebAppContext().getClassLoader().getParent(), true, this.getWebAppContext().getInitParameter(__container_pattern), false, new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (Configuration.this.getWebAppContext().isSystemClass(name)) {
                    return false;
                }
                return Configuration.this.getWebAppContext().isServerClass(name);
            }

            public boolean shouldOverride(String name) {
                return Configuration.this.getWebAppContext().isParentLoaderPriority();
            }
        });
        Log.debug((String)"Scanning WEB-INF/lib jars");
        finder.find(this.getWebAppContext().getClassLoader(), false, this.getWebAppContext().getInitParameter(__web_inf_pattern), true, new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (Configuration.this.getWebAppContext().isSystemClass(name)) {
                    return true;
                }
                if (Configuration.this.getWebAppContext().isServerClass(name)) {
                    return false;
                }
                return false;
            }

            public boolean shouldOverride(String name) {
                return !Configuration.this.getWebAppContext().isParentLoaderPriority();
            }
        });
        Log.debug((String)"Scanning classes in WEB-INF/classes");
        finder.find(this._context.getWebInf().addPath("classes/"), new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (Configuration.this.getWebAppContext().isSystemClass(name)) {
                    return true;
                }
                if (Configuration.this.getWebAppContext().isServerClass(name)) {
                    return false;
                }
                return false;
            }

            public boolean shouldOverride(String name) {
                return !Configuration.this.getWebAppContext().isParentLoaderPriority();
            }
        });
        AnnotationProcessor processor = new AnnotationProcessor(this.getWebAppContext(), finder, this._runAsCollection, this._injections, this._callbacks, LazyList.getList((Object)this._servlets), LazyList.getList((Object)this._filters), LazyList.getList((Object)this._listeners), LazyList.getList((Object)this._servletMappings), LazyList.getList((Object)this._filterMappings));
        processor.process();
        this._servlets = processor.getServlets();
        this._filters = processor.getFilters();
        this._servletMappings = processor.getServletMappings();
        this._filterMappings = processor.getFilterMappings();
        this._listeners = processor.getListeners();
        this._servletHandler.setFilters((FilterHolder[])LazyList.toArray((Object)this._filters, FilterHolder.class));
        this._servletHandler.setFilterMappings((FilterMapping[])LazyList.toArray((Object)this._filterMappings, FilterMapping.class));
        this._servletHandler.setServlets((ServletHolder[])LazyList.toArray((Object)this._servlets, ServletHolder.class));
        this._servletHandler.setServletMappings((ServletMapping[])LazyList.toArray((Object)this._servletMappings, ServletMapping.class));
        this.getWebAppContext().setEventListeners((EventListener[])LazyList.toArray((Object)this._listeners, EventListener.class));
    }
}

