/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletSecurityAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServletSecurityAnnotationHandler.class);

    public ServletSecurityAnnotationHandler(WebAppContext wac) {
        super(false, wac);
    }

    public void doHandle(Class clazz) {
        ArrayList constraintMappings;
        if (!(this._context.getSecurityHandler() instanceof ConstraintAware)) {
            LOG.warn("SecurityHandler not ConstraintAware, skipping security annotation processing");
            return;
        }
        ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
        if (servletSecurity == null) {
            return;
        }
        List<ServletMapping> servletMappings = this.getServletMappings(clazz.getCanonicalName());
        if (this.constraintsExist(servletMappings, constraintMappings = ((ConstraintAware)this._context.getSecurityHandler()).getConstraintMappings())) {
            LOG.warn("Constraints already defined for " + clazz.getName() + ", skipping ServletSecurity annotation");
            return;
        }
        constraintMappings = new ArrayList();
        ServletSecurityElement securityElement = new ServletSecurityElement(servletSecurity);
        for (ServletMapping sm : servletMappings) {
            for (String url : sm.getPathSpecs()) {
                this._context.getMetaData().setOrigin("constraint.url." + url, (Annotation)servletSecurity, clazz);
                constraintMappings.addAll(ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)clazz.getName(), (String)url, (ServletSecurityElement)securityElement));
            }
        }
        ConstraintAware securityHandler = (ConstraintAware)this._context.getSecurityHandler();
        for (ConstraintMapping m : constraintMappings) {
            securityHandler.addConstraintMapping(m);
        }
        securityHandler.checkPathsWithUncoveredHttpMethods();
    }

    protected Constraint makeConstraint(Class servlet, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic permitOrDeny, ServletSecurity.TransportGuarantee transport) {
        return ConstraintSecurityHandler.createConstraint((String)servlet.getName(), (String[])rolesAllowed, (ServletSecurity.EmptyRoleSemantic)permitOrDeny, (ServletSecurity.TransportGuarantee)transport);
    }

    protected List<ServletMapping> getServletMappings(String className) {
        ServletMapping[] mappings;
        ArrayList<ServletMapping> results = new ArrayList<ServletMapping>();
        for (ServletMapping mapping : mappings = this._context.getServletHandler().getServletMappings()) {
            ServletHolder holder = this._context.getServletHandler().getServlet(mapping.getServletName());
            if (holder.getClassName() == null || !holder.getClassName().equals(className)) continue;
            results.add(mapping);
        }
        return results;
    }

    protected boolean constraintsExist(List<ServletMapping> servletMappings, List<ConstraintMapping> constraintMappings) {
        boolean exists = false;
        for (ServletMapping mapping : servletMappings) {
            String[] pathSpecs = mapping.getPathSpecs();
            if (pathSpecs == null) continue;
            block1: for (int i = 0; constraintMappings != null && i < constraintMappings.size() && !exists; ++i) {
                for (int j = 0; j < pathSpecs.length; ++j) {
                    if (!pathSpecs[j].equals(constraintMappings.get(i).getPathSpec())) continue;
                    exists = true;
                    continue block1;
                }
            }
        }
        return exists;
    }
}

