/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.annotation.Annotation;
import javax.servlet.Servlet;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.plus.annotation.RunAs;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunAsAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RunAsAnnotationHandler.class);

    public RunAsAnnotationHandler(WebAppContext wac) {
        super(false, wac);
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        javax.annotation.security.RunAs runAs = clazz.getAnnotation(javax.annotation.security.RunAs.class);
        if (runAs != null) {
            String role = runAs.value();
            if (role != null) {
                for (ServletHolder holder : this._context.getServletHandler().getServlets(clazz)) {
                    MetaData metaData = this._context.getMetaData();
                    Descriptor d = metaData.getOriginDescriptor(holder.getName() + ".servlet.run-as");
                    if (d != null) continue;
                    metaData.setOrigin(holder.getName() + ".servlet.run-as", (Annotation)runAs, clazz);
                    RunAs ra = new RunAs(clazz.getName(), role);
                    RunAsCollection raCollection = (RunAsCollection)this._context.getAttribute("org.eclipse.jetty.runAsCollection");
                    if (raCollection == null) {
                        raCollection = new RunAsCollection();
                        this._context.setAttribute("org.eclipse.jetty.runAsCollection", (Object)raCollection);
                    }
                    raCollection.add(ra);
                }
            } else {
                LOG.warn("Bad value for @RunAs annotation on class " + clazz.getName());
            }
        }
    }

    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation) {
        LOG.warn("@RunAs annotation not applicable for fields: " + className + "." + fieldName);
    }

    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation) {
        LOG.warn("@RunAs annotation ignored on method: " + className + "." + methodName + " " + signature);
    }
}

