/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.ComplianceUtils;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3StreamConnection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStreamOverHTTP3
implements HttpStream {
    private static final Logger LOG = LoggerFactory.getLogger(HttpStreamOverHTTP3.class);
    private final AutoLock lock = new AutoLock();
    private final ServerHTTP3StreamConnection connection;
    private final HttpChannel httpChannel;
    private final HTTP3StreamServer stream;
    private MetaData.Response responseMetaData;
    private Content.Chunk chunk;
    private boolean committed;

    public HttpStreamOverHTTP3(ServerHTTP3StreamConnection connection, HttpChannel httpChannel, HTTP3StreamServer stream) {
        this.connection = connection;
        this.httpChannel = httpChannel;
        this.stream = stream;
    }

    public String getId() {
        return String.valueOf(this.stream.getId());
    }

    public HttpChannel getHttpChannel() {
        return this.httpChannel;
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            HttpField expectField;
            MetaData.Request requestMetaData = (MetaData.Request)frame.getMetaData();
            HttpConfiguration httpConfiguration = this.httpChannel.getConnectionMetaData().getHttpConfiguration();
            Runnable handler = this.httpChannel.onRequest(requestMetaData);
            Request request = this.httpChannel.getRequest();
            ComplianceViolation.Listener listener = this.httpChannel.getComplianceViolationListener();
            listener.onRequestBegin((Attributes)request);
            ComplianceUtils.verify((HttpCompliance)httpConfiguration.getHttpCompliance(), (MetaData.Request)requestMetaData, (ComplianceViolation.Listener)listener);
            if (frame.isLast()) {
                try (AutoLock ignored = this.lock.lock();){
                    this.chunk = Content.Chunk.EOF;
                }
            }
            HttpFields fields = requestMetaData.getHttpFields();
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 request #{}/{}, {} {} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()), requestMetaData.getMethod(), requestMetaData.getHttpURI(), requestMetaData.getHttpVersion(), System.lineSeparator(), fields});
            }
            if ((expectField = fields.getField(HttpHeader.EXPECT)) != null && !HttpHeaderValue.CONTINUE.is(expectField.getValue())) {
                throw new HttpException.RuntimeException(417);
            }
            Invocable.InvocationType invocationType = Invocable.getInvocationType((Object)handler);
            return Invocable.from((Invocable.InvocationType)invocationType, () -> {
                if (this.stream.isClosed()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HTTP3 request #{}/{} skipped handling, stream already closed {}", new Object[]{this.stream.getId(), Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()), this.stream});
                    }
                } else {
                    handler.run();
                }
            });
        }
        catch (Throwable x) {
            HttpException.RuntimeException runtimeException;
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("onRequest() failure");
            }
            if (x instanceof HttpException) {
                HttpException http = (HttpException)x;
                runtimeException = http;
            } else {
                runtimeException = new HttpException.RuntimeException(500, x);
            }
            HttpException.RuntimeException httpException = runtimeException;
            return this.onBadMessage((HttpException)httpException);
        }
    }

    private Runnable onBadMessage(HttpException x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("badMessage {} {}", (Object)this, (Object)x);
        }
        Throwable failure = (Throwable)x;
        return this.httpChannel.onFailure(failure);
    }

    public Content.Chunk read() {
        while (true) {
            Content.Chunk chunk;
            try (AutoLock ignored = this.lock.lock();){
                chunk = this.chunk;
                this.chunk = Content.Chunk.next((Content.Chunk)chunk);
            }
            if (chunk != null) {
                return chunk;
            }
            chunk = this.stream.read();
            if (chunk == null) {
                return null;
            }
            if (this.store(chunk)) continue;
            chunk.release();
        }
    }

    public void demand() {
        boolean notify;
        try (AutoLock ignored = this.lock.lock();){
            notify = this.chunk != null;
        }
        if (notify) {
            Runnable task = this.httpChannel.onContentAvailable();
            if (task != null) {
                this.connection.offerTask(task, true);
            }
        } else {
            this.stream.demand();
        }
    }

    public Runnable onDataAvailable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 request data available #{}/{}", (Object)this.stream.getId(), (Object)Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()));
        }
        return this.httpChannel.onContentAvailable();
    }

    private boolean store(Content.Chunk chunk) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.chunk != null) {
                boolean bl = false;
                return bl;
            }
            this.chunk = chunk;
            boolean bl = true;
            return bl;
        }
    }

    public Runnable onTrailer(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getHttpFields().asImmutable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Request #{}/{}, trailer:{}{}", new Object[]{this.stream.getId(), Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()), System.lineSeparator(), trailers});
        }
        try (AutoLock ignored = this.lock.lock();){
            this.chunk = new Trailers(trailers);
        }
        return this.httpChannel.onContentAvailable();
    }

    public void prepareResponse(HttpFields.Mutable headers) {
    }

    public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer byteBuffer, Callback callback) {
        ByteBuffer content;
        ByteBuffer byteBuffer2 = content = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
        if (response != null) {
            this.sendHeaders(request, response, content, last, callback);
        } else {
            this.sendContent(request, content, last, callback);
        }
    }

    public Runnable cancelSend(final Throwable cause, final Callback appCallback) {
        return () -> this.stream.disconnect(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), cause, (Promise.Invocable)new Promise.Invocable.Abstract<Stream>(this, appCallback.getInvocationType()){
            final /* synthetic */ HttpStreamOverHTTP3 this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public void succeeded(Stream result) {
                this.completed();
            }

            public void failed(Throwable x) {
                this.completed();
            }

            private void completed() {
                appCallback.failed(cause);
            }
        });
    }

    private void sendHeaders(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean lastContent, Callback callback) {
        HeadersFrame headersFrame;
        boolean hasContent;
        this.responseMetaData = response;
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (HttpStatus.isInterim((int)response.getStatus())) {
            if (hasContent) {
                callback.failed((Throwable)new IllegalStateException("Interim response cannot have content"));
                return;
            }
            headersFrame = new HeadersFrame((MetaData)response, false);
        } else {
            this.committed = true;
            if (lastContent) {
                long realContentLength = BufferUtil.length((ByteBuffer)content);
                long contentLength = response.getContentLength();
                if (contentLength < 0L) {
                    this.responseMetaData = new MetaData.Response(response.getStatus(), response.getReason(), response.getHttpVersion(), response.getHttpFields(), realContentLength, response.getTrailersSupplier());
                } else if (hasContent && contentLength != realContentLength) {
                    callback.failed((Throwable)new HttpException.RuntimeException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, realContentLength)));
                    return;
                }
            }
            if (hasContent) {
                headersFrame = new HeadersFrame((MetaData)response, false);
                if (lastContent) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        dataFrame = new DataFrame(content, true);
                    } else {
                        dataFrame = new DataFrame(content, false);
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    }
                } else {
                    dataFrame = new DataFrame(content, false);
                }
            } else if (lastContent) {
                if (this.isTunnel(request, response)) {
                    headersFrame = new HeadersFrame((MetaData)response, false);
                } else {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        headersFrame = new HeadersFrame((MetaData)response, true);
                    } else {
                        headersFrame = new HeadersFrame((MetaData)response, false);
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    }
                }
            } else {
                headersFrame = new HeadersFrame((MetaData)response, false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 response #{}/{}:{}{} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()), System.lineSeparator(), HttpVersion.HTTP_3, response.getStatus(), System.lineSeparator(), response.getHttpFields()});
        }
        DataFrame df = dataFrame;
        HeadersFrame tf = trailersFrame;
        this.stream.respond(headersFrame, (Promise.Invocable<Stream>)Promise.Invocable.from((Invocable.InvocationType)callback.getInvocationType(), s -> {
            if (df != null) {
                if (tf != null) {
                    this.sendDataAndTrailer(df, lastContent, tf, callback);
                } else {
                    this.sendData(df, lastContent, callback);
                }
            } else if (tf != null) {
                this.sendTrailer(tf, callback);
            } else {
                callback.succeeded();
            }
        }, arg_0 -> ((Callback)callback).failed(arg_0)));
    }

    private void sendContent(MetaData.Request request, ByteBuffer content, boolean lastContent, Callback callback) {
        boolean hasContent;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (hasContent || lastContent && !this.isTunnel(request, this.responseMetaData)) {
            if (!hasContent) {
                content = BufferUtil.EMPTY_BUFFER;
            }
            if (lastContent) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    DataFrame df = new DataFrame(content, true);
                    this.sendData(df, true, callback);
                } else if (hasContent) {
                    DataFrame df = new DataFrame(content, false);
                    HeadersFrame tf = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    this.sendDataAndTrailer(df, true, tf, callback);
                } else {
                    HeadersFrame tf = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    this.sendTrailer(tf, callback);
                }
            } else {
                DataFrame df = new DataFrame(content, false);
                this.sendData(df, false, callback);
            }
        } else {
            callback.succeeded();
        }
    }

    private HttpFields retrieveTrailers() {
        Supplier supplier = this.responseMetaData.getTrailersSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = (HttpFields)supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    private boolean isTunnel(MetaData.Request request, MetaData.Response response) {
        return MetaData.isTunnel((String)request.getMethod(), (int)response.getStatus());
    }

    private void sendDataAndTrailer(DataFrame dataFrame, boolean lastContent, HeadersFrame trailersFrame, Callback callback) {
        this.sendData(dataFrame, lastContent, Callback.from((Invocable.InvocationType)callback.getInvocationType(), () -> this.sendTrailer(trailersFrame, callback), arg_0 -> ((Callback)callback).failed(arg_0)));
    }

    private void sendData(DataFrame dataFrame, boolean lastContent, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 response #{}/{}: {} content bytes{}", new Object[]{this.stream.getId(), Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()), dataFrame.getByteBuffer().remaining(), lastContent ? " (last chunk)" : ""});
        }
        this.stream.data(dataFrame, Promise.Invocable.from((Invocable.InvocationType)callback.getInvocationType(), s -> callback.succeeded(), arg_0 -> ((Callback)callback).failed(arg_0)));
    }

    private void sendTrailer(HeadersFrame trailerFrame, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 response #{}/{}: trailer{}{}", new Object[]{this.stream.getId(), Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()), System.lineSeparator(), trailerFrame.getMetaData().getHttpFields()});
        }
        this.stream.trailer(trailerFrame, Promise.Invocable.from((Invocable.InvocationType)callback.getInvocationType(), s -> callback.succeeded(), arg_0 -> ((Callback)callback).failed(arg_0)));
    }

    public long getIdleTimeout() {
        return this.stream.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeoutMs) {
        this.stream.setIdleTimeout(idleTimeoutMs);
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public Throwable consumeAvailable() {
        if (this.getTunnelSupport() != null) {
            return null;
        }
        Throwable result = HttpStream.consumeAvailable((HttpStream)this, (HttpConfiguration)this.httpChannel.getConnectionMetaData().getHttpConfiguration());
        if (result != null) {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.chunk = Content.Chunk.from((Throwable)result, (boolean)true);
        }
        return result;
    }

    public boolean isIdle() {
        return true;
    }

    public void succeeded() {
        this.httpChannel.recycle();
        if (!this.stream.isClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 Response #{}/{}: unconsumed request content, resetting stream", (Object)this.stream.getId(), (Object)Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()));
            }
            this.stream.disconnect(HTTP3ErrorCode.NO_ERROR.code(), CONTENT_NOT_CONSUMED, Promise.Invocable.noop());
        }
    }

    public void failed(Throwable x) {
        HTTP3ErrorCode errorCode;
        HTTP3ErrorCode hTTP3ErrorCode = errorCode = x == HttpStream.CONTENT_NOT_CONSUMED ? HTTP3ErrorCode.NO_ERROR : HTTP3ErrorCode.REQUEST_CANCELLED_ERROR;
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(x).log("HTTP3 Response #{}/{} failed {}", new Object[]{this.stream.getId(), Integer.toHexString(((Object)((Object)this.stream.getSession())).hashCode()), errorCode});
        }
        this.stream.disconnect(errorCode.code(), x, Promise.Invocable.noop());
    }

    public void onIdleTimeout(TimeoutException failure, BiConsumer<Runnable, Boolean> consumer) {
        HttpChannel.IdleTimeoutTask task = this.httpChannel.onIdleTimeout(failure);
        consumer.accept(task.action(), !task.handlingRequest());
    }

    public Runnable onFailure(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.chunk = Content.Chunk.from((Throwable)failure, (boolean)true);
        }
        this.connection.onFailure(failure);
        boolean remote = failure instanceof EOFException;
        return remote ? this.httpChannel.onRemoteFailure((Throwable)new EofException(failure)) : this.httpChannel.onFailure(failure);
    }
}

