/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.server.AbstractHTTP3ServerConnectionFactory;
import org.eclipse.jetty.http3.server.internal.HTTP3SessionServer;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.HttpStreamOverHTTP3;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3StreamConnection;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3ServerConnectionFactory
extends AbstractHTTP3ServerConnectionFactory {
    public HTTP3ServerConnectionFactory() {
        this(new HttpConfiguration());
    }

    public HTTP3ServerConnectionFactory(HttpConfiguration configuration) {
        super(configuration, new HTTP3SessionListener());
        configuration.addCustomizer((HttpConfiguration.Customizer)new AltSvcCustomizer());
    }

    private static class HTTP3SessionListener
    implements HTTP3SessionServer.Listener {
        private static final Logger LOG = LoggerFactory.getLogger(HTTP3SessionListener.class);

        private HTTP3SessionListener() {
        }

        public Stream.Server.Listener onRequest(Session.Server session, HeadersFrame frame) {
            return new HTTP3StreamListener();
        }

        public boolean onIdleTimeout(Session session) {
            boolean result = session.getStreams().stream().map(stream -> (HTTP3Stream)stream).map(stream -> (HttpStreamOverHTTP3)stream.getAttachment()).filter(Objects::nonNull).map(HttpStreamOverHTTP3::isIdle).reduce(true, Boolean::logicalAnd);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} idle timeout on {}", (Object)(result ? "confirmed" : "ignored"), (Object)session);
            }
            return result;
        }

        public void onFailure(Session session, long error, String reason, Throwable failure) {
            session.getStreams().stream().map(stream -> (HTTP3Stream)stream).forEach(stream -> stream.onFailure(error, failure));
        }

        @Override
        public void onStreamFailure(Stream stream, Throwable failure) {
            HTTP3Stream http3Stream = (HTTP3Stream)stream;
            ServerHTTP3StreamConnection connection = (ServerHTTP3StreamConnection)http3Stream.getStreamEndPoint().getConnection();
            Runnable task = connection.onFailure(http3Stream, failure);
            Executor executor = http3Stream.getSession().getProtocolSession().getExecutor();
            ThreadPool.executeImmediately((Executor)executor, (Runnable)task);
        }
    }

    private static class AltSvcCustomizer
    implements HttpConfiguration.Customizer {
        private AltSvcCustomizer() {
        }

        public Request customize(Request request, HttpFields.Mutable responseHeaders) {
            ConnectionMetaData connectionMetaData = request.getConnectionMetaData();
            Connector connector = connectionMetaData.getConnector();
            if (connector instanceof NetworkConnector) {
                NetworkConnector networkConnector = (NetworkConnector)connector;
                if (HttpVersion.HTTP_2 == connectionMetaData.getHttpVersion()) {
                    responseHeaders.add(HttpHeader.ALT_SVC, String.format("h3=\":%d\"", networkConnector.getLocalPort()));
                }
            }
            return request;
        }
    }

    private static class HTTP3StreamListener
    implements Stream.Server.Listener,
    Invocable {
        private HTTP3Stream http3Stream;

        private HTTP3StreamListener() {
        }

        public void onRequest(Stream.Server stream, HeadersFrame frame) {
            HTTP3StreamServer http3Stream = (HTTP3StreamServer)stream;
            this.http3Stream = http3Stream;
            this.getConnection().onRequest(http3Stream, frame);
        }

        public void onDataAvailable(Stream.Server stream, boolean immediate) {
            ServerHTTP3StreamConnection connection = this.getConnection();
            connection.onDataAvailable(this.http3Stream, immediate);
        }

        public void onTrailer(Stream.Server stream, HeadersFrame frame) {
            ServerHTTP3StreamConnection connection = this.getConnection();
            connection.onTrailer(this.http3Stream, frame);
        }

        public void onIdleTimeout(Stream.Server stream, TimeoutException timeout, Promise<Boolean> promise) {
            this.getConnection().onIdleTimeout(this.http3Stream, timeout, (Runnable task, Boolean timedOut) -> {
                if (task == null) {
                    promise.succeeded(timedOut);
                    return;
                }
                Executor executor = this.http3Stream.getSession().getProtocolSession().getExecutor();
                ThreadPool.executeImmediately((Executor)executor, () -> {
                    try {
                        task.run();
                        promise.succeeded(timedOut);
                    }
                    catch (Throwable x) {
                        promise.failed(x);
                    }
                });
            });
        }

        public void onFailure(Stream.Server stream, long error, Throwable failure) {
            Runnable task = this.getConnection().onFailure(this.http3Stream, failure);
            Executor executor = this.http3Stream.getSession().getProtocolSession().getExecutor();
            ThreadPool.executeImmediately((Executor)executor, (Runnable)task);
        }

        public Invocable.InvocationType getInvocationType() {
            HttpStreamOverHTTP3 httpStream = (HttpStreamOverHTTP3)this.http3Stream.getAttachment();
            return httpStream.getHttpChannel().getInvocationType();
        }

        private ServerHTTP3StreamConnection getConnection() {
            return (ServerHTTP3StreamConnection)this.http3Stream.getStreamEndPoint().getConnection();
        }
    }
}

