/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.HTTP3StreamConnection;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.parser.MessageParser;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.HttpStreamOverHTTP3;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3Session;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.HostPort;

public class ServerHTTP3StreamConnection
extends HTTP3StreamConnection {
    private final HttpChannel.Factory httpChannelFactory = new HttpChannel.DefaultFactory();
    private final Attributes attributes = new Attributes.Lazy();
    private final Connector connector;
    private final HttpConfiguration httpConfiguration;
    private final ServerHTTP3Session session;

    public ServerHTTP3StreamConnection(Connector connector, HttpConfiguration httpConfiguration, QuicStreamEndPoint endPoint, ServerHTTP3Session session, MessageParser parser) {
        super(endPoint, connector.getExecutor(), connector.getByteBufferPool(), parser, httpConfiguration.getMinInputBufferSpace());
        this.connector = connector;
        this.httpConfiguration = httpConfiguration;
        this.session = session;
    }

    public Runnable onRequest(HTTP3StreamServer stream, HeadersFrame frame) {
        HttpChannel httpChannel = this.httpChannelFactory.newHttpChannel((ConnectionMetaData)new MetaData());
        httpChannel.initialize();
        HttpStreamOverHTTP3 httpStream = new HttpStreamOverHTTP3(this, httpChannel, stream);
        httpChannel.setHttpStream((HttpStream)httpStream);
        stream.setAttachment(httpStream);
        return httpStream.onRequest(frame);
    }

    public Runnable onDataAvailable(HTTP3Stream stream) {
        HttpStreamOverHTTP3 httpStream = (HttpStreamOverHTTP3)stream.getAttachment();
        return httpStream.onDataAvailable();
    }

    public Runnable onTrailer(HTTP3Stream stream, HeadersFrame frame) {
        HttpStreamOverHTTP3 httpStream = (HttpStreamOverHTTP3)stream.getAttachment();
        return httpStream.onTrailer(frame);
    }

    public void onIdleTimeout(HTTP3Stream stream, TimeoutException timeout, BiConsumer<Runnable, Boolean> consumer) {
        HttpStreamOverHTTP3 httpStream = (HttpStreamOverHTTP3)stream.getAttachment();
        httpStream.onIdleTimeout(timeout, consumer);
    }

    public Runnable onFailure(HTTP3Stream stream, Throwable failure) {
        HttpStreamOverHTTP3 httpStream = (HttpStreamOverHTTP3)stream.getAttachment();
        return httpStream.onFailure(failure);
    }

    void offer(Runnable task) {
        this.session.offer(task, false);
    }

    private class MetaData
    implements ConnectionMetaData {
        private final SocketAddress localSocketAddress;
        private final SocketAddress remoteSocketAddress;

        private MetaData() {
            this.localSocketAddress = ServerHTTP3StreamConnection.this.httpConfiguration.getLocalAddress() == null ? ServerHTTP3StreamConnection.this.getEndPoint().getLocalSocketAddress() : ServerHTTP3StreamConnection.this.httpConfiguration.getLocalAddress();
            this.remoteSocketAddress = ServerHTTP3StreamConnection.this.getEndPoint().getRemoteSocketAddress();
        }

        public String getId() {
            return ServerHTTP3StreamConnection.this.session.getQuicSession().getConnectionId().toString();
        }

        public HttpConfiguration getHttpConfiguration() {
            return ServerHTTP3StreamConnection.this.httpConfiguration;
        }

        public HttpVersion getHttpVersion() {
            return HttpVersion.HTTP_3;
        }

        public String getProtocol() {
            return this.getHttpVersion().asString();
        }

        public Connection getConnection() {
            return ServerHTTP3StreamConnection.this.getEndPoint().getConnection();
        }

        public Connector getConnector() {
            return ServerHTTP3StreamConnection.this.connector;
        }

        public boolean isPersistent() {
            return true;
        }

        public boolean isSecure() {
            return true;
        }

        public SocketAddress getRemoteSocketAddress() {
            return this.remoteSocketAddress;
        }

        public SocketAddress getLocalSocketAddress() {
            return this.localSocketAddress;
        }

        public HostPort getServerAuthority() {
            HostPort override = ServerHTTP3StreamConnection.this.httpConfiguration.getServerAuthority();
            if (override != null) {
                return override;
            }
            SocketAddress addr = this.getLocalSocketAddress();
            if (addr instanceof InetSocketAddress) {
                InetSocketAddress inet = (InetSocketAddress)addr;
                return new HostPort(inet.getHostString(), inet.getPort());
            }
            return new HostPort(addr.toString(), -1);
        }

        public Object getAttribute(String name) {
            return ServerHTTP3StreamConnection.this.attributes.getAttribute(name);
        }

        public Object setAttribute(String name, Object attribute) {
            return ServerHTTP3StreamConnection.this.attributes.setAttribute(name, attribute);
        }

        public Object removeAttribute(String name) {
            return ServerHTTP3StreamConnection.this.attributes.removeAttribute(name);
        }

        public Set<String> getAttributeNameSet() {
            return ServerHTTP3StreamConnection.this.attributes.getAttributeNameSet();
        }

        public void clearAttributes() {
            ServerHTTP3StreamConnection.this.attributes.clearAttributes();
        }
    }
}

