/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3StreamConnection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStreamOverHTTP3
implements HttpStream {
    private static final Logger LOG = LoggerFactory.getLogger(HttpStreamOverHTTP3.class);
    private final AutoLock lock = new AutoLock();
    private final ServerHTTP3StreamConnection connection;
    private final HttpChannel httpChannel;
    private final HTTP3StreamServer stream;
    private MetaData.Request requestMetaData;
    private MetaData.Response responseMetaData;
    private Content.Chunk chunk;
    private boolean committed;

    public HttpStreamOverHTTP3(ServerHTTP3StreamConnection connection, HttpChannel httpChannel, HTTP3StreamServer stream) {
        this.connection = connection;
        this.httpChannel = httpChannel;
        this.stream = stream;
    }

    public String getId() {
        return String.valueOf(this.stream.getId());
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            HttpField expectField;
            this.requestMetaData = (MetaData.Request)frame.getMetaData();
            ComplianceViolation.Listener listener = this.httpChannel.getComplianceViolationListener();
            Runnable handler = this.httpChannel.onRequest(this.requestMetaData);
            Request request = this.httpChannel.getRequest();
            listener.onRequestBegin((Attributes)request);
            HttpCompliance httpCompliance = this.httpChannel.getConnectionMetaData().getHttpConfiguration().getHttpCompliance();
            HttpCompliance.checkHttpCompliance((MetaData.Request)this.requestMetaData, (HttpCompliance)httpCompliance, (ComplianceViolation.Listener)listener);
            if (frame.isLast()) {
                try (AutoLock ignored = this.lock.lock();){
                    this.chunk = Content.Chunk.EOF;
                }
            }
            HttpFields fields = this.requestMetaData.getHttpFields();
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 request #{}/{}, {} {} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), this.requestMetaData.getMethod(), this.requestMetaData.getHttpURI(), this.requestMetaData.getHttpVersion(), System.lineSeparator(), fields});
            }
            if ((expectField = fields.getField(HttpHeader.EXPECT)) != null && !HttpHeaderValue.CONTINUE.is(expectField.getValue())) {
                throw new BadMessageException(417);
            }
            Invocable.InvocationType invocationType = Invocable.getInvocationType((Object)handler);
            return new Invocable.ReadyTask(invocationType, handler){

                public void run() {
                    if (HttpStreamOverHTTP3.this.stream.isClosed()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("HTTP3 request #{}/{} skipped handling, stream already closed {}", new Object[]{HttpStreamOverHTTP3.this.stream.getId(), Integer.toHexString(HttpStreamOverHTTP3.this.stream.getSession().hashCode()), HttpStreamOverHTTP3.this.stream});
                        }
                    } else {
                        super.run();
                    }
                }
            };
        }
        catch (Throwable x) {
            HttpException.RuntimeException runtimeException;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onRequest() failure", x);
            }
            if (x instanceof HttpException) {
                HttpException http = (HttpException)x;
                runtimeException = http;
            } else {
                runtimeException = new HttpException.RuntimeException(500, x);
            }
            HttpException.RuntimeException httpException = runtimeException;
            return this.onBadMessage((HttpException)httpException);
        }
    }

    private Runnable onBadMessage(HttpException x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("badMessage {} {}", (Object)this, (Object)x);
        }
        Throwable failure = (Throwable)x;
        return this.httpChannel.onFailure(failure);
    }

    public Content.Chunk read() {
        while (true) {
            Content.Chunk chunk;
            try (AutoLock ignored = this.lock.lock();){
                chunk = this.chunk;
                this.chunk = Content.Chunk.next((Content.Chunk)chunk);
            }
            if (chunk != null) {
                return chunk;
            }
            Stream.Data data = this.stream.readData();
            if (data == null) {
                return null;
            }
            chunk = this.createChunk(data);
            AutoLock ignored = this.lock.lock();
            try {
                this.chunk = chunk;
                continue;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
    }

    public void demand() {
        boolean notify;
        try (AutoLock ignored = this.lock.lock();){
            notify = this.chunk != null;
        }
        if (notify) {
            Runnable task = this.httpChannel.onContentAvailable();
            if (task != null) {
                this.connection.offer(task, true);
            }
        } else {
            this.stream.demand();
        }
    }

    public Runnable onDataAvailable() {
        Stream.Data data;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 request data available #{}/{}", (Object)this.stream.getId(), (Object)Integer.toHexString(this.stream.getSession().hashCode()));
        }
        if ((data = this.stream.readData()) == null) {
            this.stream.demand();
            return null;
        }
        Content.Chunk chunk = this.createChunk(data);
        try (AutoLock ignored = this.lock.lock();){
            this.chunk = chunk;
        }
        return this.httpChannel.onContentAvailable();
    }

    public Runnable onTrailer(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getHttpFields().asImmutable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Request #{}/{}, trailer:{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        try (AutoLock ignored = this.lock.lock();){
            this.chunk = new Trailers(trailers);
        }
        return this.httpChannel.onContentAvailable();
    }

    private Content.Chunk createChunk(Stream.Data data) {
        if (data == Stream.Data.EOF) {
            data.release();
            return Content.Chunk.EOF;
        }
        return Content.Chunk.asChunk((ByteBuffer)data.getByteBuffer(), (boolean)data.isLast(), (Retainable)data);
    }

    public void prepareResponse(HttpFields.Mutable headers) {
    }

    public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer byteBuffer, Callback callback) {
        ByteBuffer content;
        ByteBuffer byteBuffer2 = content = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
        if (response != null) {
            this.sendHeaders(request, response, content, last, callback);
        } else {
            this.sendContent(request, content, last, callback);
        }
    }

    private void sendHeaders(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean lastContent, Callback callback) {
        HeadersFrame tf;
        HeadersFrame headersFrame;
        boolean hasContent;
        this.responseMetaData = response;
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (HttpStatus.isInterim((int)response.getStatus())) {
            if (hasContent) {
                callback.failed((Throwable)new IllegalStateException("Interim response cannot have content"));
                return;
            }
            headersFrame = new HeadersFrame((MetaData)response, false);
        } else {
            this.committed = true;
            if (lastContent) {
                long realContentLength = BufferUtil.length((ByteBuffer)content);
                long contentLength = response.getContentLength();
                if (contentLength < 0L) {
                    this.responseMetaData = new MetaData.Response(response.getStatus(), response.getReason(), response.getHttpVersion(), response.getHttpFields(), realContentLength, response.getTrailersSupplier());
                } else if (hasContent && contentLength != realContentLength) {
                    callback.failed((Throwable)new HttpException.RuntimeException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, realContentLength)));
                    return;
                }
            }
            if (hasContent) {
                headersFrame = new HeadersFrame((MetaData)response, false);
                if (lastContent) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        dataFrame = new DataFrame(content, true);
                    } else {
                        dataFrame = new DataFrame(content, false);
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    }
                } else {
                    dataFrame = new DataFrame(content, false);
                }
            } else if (lastContent) {
                if (this.isTunnel(request, response)) {
                    headersFrame = new HeadersFrame((MetaData)response, false);
                } else {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        headersFrame = new HeadersFrame((MetaData)response, true);
                    } else {
                        headersFrame = new HeadersFrame((MetaData)response, false);
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    }
                }
            } else {
                headersFrame = new HeadersFrame((MetaData)response, false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Response #{}/{}:{}{} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_3, response.getStatus(), System.lineSeparator(), response.getHttpFields()});
        }
        CompletionStage<Object> cf = this.stream.respond(headersFrame);
        DataFrame df = dataFrame;
        if (df != null) {
            cf = ((CompletableFuture)cf).thenCompose(s -> s.data(df));
        }
        if ((tf = trailersFrame) != null) {
            cf = ((CompletableFuture)cf).thenCompose(s -> s.trailer(tf));
        }
        callback.completeWith(cf);
    }

    private void sendContent(MetaData.Request request, ByteBuffer content, boolean lastContent, Callback callback) {
        boolean hasContent;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (hasContent || lastContent && !this.isTunnel(request, this.responseMetaData)) {
            if (!hasContent) {
                content = BufferUtil.EMPTY_BUFFER;
            }
            if (lastContent) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    callback.completeWith(this.sendDataFrame(content, true, true));
                } else if (hasContent) {
                    callback.completeWith((CompletableFuture)this.sendDataFrame(content, false, false).thenCompose(s -> this.sendTrailerFrame(trailers)));
                } else {
                    callback.completeWith(this.sendTrailerFrame(trailers));
                }
            } else {
                callback.completeWith(this.sendDataFrame(content, false, false));
            }
        } else {
            callback.succeeded();
        }
    }

    private HttpFields retrieveTrailers() {
        Supplier supplier = this.responseMetaData.getTrailersSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = (HttpFields)supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    private boolean isTunnel(MetaData.Request request, MetaData.Response response) {
        return MetaData.isTunnel((String)request.getMethod(), (int)response.getStatus());
    }

    private CompletableFuture<Stream> sendDataFrame(ByteBuffer content, boolean lastContent, boolean endStream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Response #{}/{}: {} content bytes{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(content, endStream);
        return this.stream.data(frame);
    }

    private CompletableFuture<Stream> sendTrailerFrame(HttpFields trailers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Response #{}/{}: trailer{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        HeadersFrame frame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
        return this.stream.trailer(frame);
    }

    public long getIdleTimeout() {
        return this.stream.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeoutMs) {
        this.stream.setIdleTimeout(idleTimeoutMs);
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public Throwable consumeAvailable() {
        if (this.getTunnelSupport() != null) {
            return null;
        }
        Throwable result = HttpStream.consumeAvailable((HttpStream)this, (HttpConfiguration)this.httpChannel.getConnectionMetaData().getHttpConfiguration());
        if (result != null) {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.chunk = Content.Chunk.from((Throwable)result, (boolean)true);
        }
        return result;
    }

    public boolean isIdle() {
        return true;
    }

    public void succeeded() {
        this.httpChannel.recycle();
        if (!this.stream.isClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 Response #{}/{}: unconsumed request content, resetting stream", (Object)this.stream.getId(), (Object)Integer.toHexString(this.stream.getSession().hashCode()));
            }
            this.stream.reset(HTTP3ErrorCode.NO_ERROR.code(), CONTENT_NOT_CONSUMED);
        }
    }

    public void failed(Throwable x) {
        HTTP3ErrorCode errorCode;
        HTTP3ErrorCode hTTP3ErrorCode = errorCode = x == HttpStream.CONTENT_NOT_CONSUMED ? HTTP3ErrorCode.NO_ERROR : HTTP3ErrorCode.REQUEST_CANCELLED_ERROR;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Response #{}/{} failed {}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), errorCode, x});
        }
        this.stream.reset(errorCode.code(), x);
    }

    public void onIdleTimeout(TimeoutException failure, BiConsumer<Runnable, Boolean> consumer) {
        Runnable runnable = this.httpChannel.onIdleTimeout(failure);
        boolean idle = !this.httpChannel.isRequestHandled();
        consumer.accept(runnable, idle);
    }

    public Runnable onFailure(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.chunk = Content.Chunk.from((Throwable)failure, (boolean)true);
        }
        this.connection.onFailure(failure);
        boolean remote = failure instanceof EOFException;
        return remote ? this.httpChannel.onRemoteFailure((Throwable)new EofException(failure)) : this.httpChannel.onFailure(failure);
    }
}

