/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;

public class SetCapacityInstruction
implements Instruction {
    private final int _capacity;

    public SetCapacityInstruction(int capacity) {
        this._capacity = capacity;
    }

    public int getCapacity() {
        return this._capacity;
    }

    @Override
    public void encode(ByteBufferPool byteBufferPool, RetainableByteBuffer.Mutable accumulator) {
        int size = NBitIntegerEncoder.octetsNeeded((int)5, (long)this._capacity);
        RetainableByteBuffer.Mutable retainableByteBuffer = byteBufferPool.acquire(size, true);
        ByteBuffer buffer = retainableByteBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)buffer);
        buffer.put((byte)32);
        NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)5, (long)this._capacity);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        accumulator.add((RetainableByteBuffer)retainableByteBuffer);
    }

    public String toString() {
        return String.format("%s@%x[capacity=%d]", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getCapacity());
    }
}

