/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal;

import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http3.qpack.internal.table.DynamicTable;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;
import org.eclipse.jetty.http3.qpack.internal.table.StaticTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpackContext {
    private static final Logger LOG = LoggerFactory.getLogger(QpackContext.class);
    private static final StaticTable __staticTable = new StaticTable();
    private final DynamicTable _dynamicTable = new DynamicTable();

    public DynamicTable getDynamicTable() {
        return this._dynamicTable;
    }

    public static StaticTable getStaticTable() {
        return __staticTable;
    }

    public Entry get(HttpField field) {
        Entry entry = this._dynamicTable.get(field);
        if (entry == null) {
            entry = __staticTable.get(field);
        }
        return entry;
    }

    public Entry get(String name) {
        Entry entry = __staticTable.get(name);
        if (entry != null) {
            return entry;
        }
        return this._dynamicTable.get(name);
    }

    public int indexOf(Entry entry) {
        if (entry.isStatic()) {
            return entry.getIndex();
        }
        return this._dynamicTable.relativeIndexOf(entry);
    }
}

