/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.generator;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.generator.FrameGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.util.VarLenInt;
import org.eclipse.jetty.util.BufferUtil;

public class SettingsGenerator
extends FrameGenerator {
    private final boolean useDirectByteBuffers;

    public SettingsGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        super(bufferPool);
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public long generate(ByteBufferPool.Accumulator accumulator, long streamId, Frame frame, Consumer<Throwable> fail) {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        return this.generateSettings(accumulator, settingsFrame);
    }

    private long generateSettings(ByteBufferPool.Accumulator accumulator, SettingsFrame frame) {
        int length = 0;
        Map<Long, Long> settings = frame.getSettings();
        for (Map.Entry<Long, Long> e : settings.entrySet()) {
            length += VarLenInt.length((long)e.getKey()) + VarLenInt.length((long)e.getValue());
        }
        int capacity = VarLenInt.length((long)frame.getFrameType().type()) + VarLenInt.length((long)length) + length;
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(capacity, this.useDirectByteBuffers);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frame.getFrameType().type());
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)length);
        for (Map.Entry<Long, Long> e : settings.entrySet()) {
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)e.getKey());
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)e.getValue());
        }
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
        accumulator.append((RetainableByteBuffer)buffer);
        return capacity;
    }
}

