/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.frames;

import java.util.HashMap;
import java.util.Map;

public enum FrameType {
    DATA(0),
    HEADERS(1),
    CANCEL_PUSH(3),
    SETTINGS(4),
    PUSH_PROMISE(5),
    GOAWAY(7),
    MAX_PUSH_ID(13);

    private final int type;

    public static FrameType from(long type) {
        return Types.types.get(type);
    }

    public static boolean isControl(long frameType) {
        return frameType == (long)CANCEL_PUSH.type() || frameType == (long)SETTINGS.type() || frameType == (long)GOAWAY.type() || frameType == (long)MAX_PUSH_ID.type();
    }

    public static boolean isMessage(long frameType) {
        return frameType == (long)DATA.type() || frameType == (long)HEADERS.type() || frameType == (long)PUSH_PROMISE.type();
    }

    public static int maxType() {
        return MAX_PUSH_ID.type();
    }

    private FrameType(int type) {
        this.type = type;
        Types.types.put(Long.valueOf(type), this);
    }

    public int type() {
        return this.type;
    }

    private static class Types {
        private static final Map<Long, FrameType> types = new HashMap<Long, FrameType>();

        private Types() {
        }
    }
}

