/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.StreamType;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.generator.ControlGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.quic.util.VarLenInt;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlFlusher
extends IteratingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ControlFlusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Entry> queue = new ArrayDeque<Entry>();
    private final StreamEndPoint endPoint;
    private final ControlGenerator generator;
    private final ByteBufferPool.Accumulator accumulator;
    private boolean initialized;
    private Throwable terminated;
    private List<Entry> entries;
    private Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;

    public ControlFlusher(ByteBufferPool byteBufferPool, StreamEndPoint endPoint, boolean useDirectByteBuffers) {
        this.endPoint = endPoint;
        this.generator = new ControlGenerator(byteBufferPool, useDirectByteBuffers);
        this.accumulator = new ByteBufferPool.Accumulator();
    }

    public boolean offer(Frame frame, Callback callback) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                this.queue.offer(new Entry(frame, callback));
            }
        }
        if (closed == null) {
            return true;
        }
        callback.failed(closed);
        return false;
    }

    protected IteratingCallback.Action process() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.queue.isEmpty()) {
                IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                return action;
            }
            this.entries = new ArrayList<Entry>(this.queue);
            this.queue.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", this.entries, (Object)this);
        }
        for (Entry entry : this.entries) {
            this.generator.generate(this.accumulator, this.endPoint.getStream().getId(), entry.frame, null);
            this.invocationType = Invocable.combine((Invocable.InvocationType)this.invocationType, (Invocable.InvocationType)entry.callback.getInvocationType());
        }
        if (!this.initialized) {
            this.initialized = true;
            long streamType = StreamType.CONTROL_STREAM.type();
            ByteBuffer buffer = ByteBuffer.allocate(VarLenInt.length((long)streamType));
            VarLenInt.encode((ByteBuffer)buffer, (long)streamType);
            buffer.flip();
            this.accumulator.insert(0, (RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)buffer));
        }
        List buffers = this.accumulator.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} buffers ({} bytes) on {}", new Object[]{buffers.size(), this.accumulator.getTotalLength(), this});
        }
        this.endPoint.write(false, buffers, (Callback)this);
        return IteratingCallback.Action.SCHEDULED;
    }

    protected void onSuccess() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("succeeded to write {} on {}", this.entries, (Object)this);
        }
        this.accumulator.release();
        this.entries.forEach(e -> e.callback.succeeded());
        this.entries.clear();
        this.invocationType = Invocable.InvocationType.NON_BLOCKING;
    }

    protected void onFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to write {} on {}", new Object[]{this.entries, this, failure});
        }
        ArrayList<Entry> allEntries = new ArrayList<Entry>(this.entries);
        this.entries.clear();
        try (AutoLock ignored = this.lock.lock();){
            this.terminated = failure;
            allEntries.addAll(this.queue);
            this.queue.clear();
        }
        allEntries.forEach(e -> e.callback.failed(failure));
        ConnectionCloseFrame frame = new ConnectionCloseFrame(HTTP3ErrorCode.INTERNAL_ERROR.code(), "control_stream_failure");
        this.endPoint.getProtocolSession().disconnect(frame, failure, Promise.Invocable.noop());
    }

    protected void onCompleteFailure(Throwable cause) {
        this.accumulator.release();
    }

    public Invocable.InvocationType getInvocationType() {
        return this.invocationType;
    }

    public String toString() {
        return String.format("%s#%s", super.toString(), this.endPoint.getStream().getId());
    }

    private record Entry(Frame frame, Callback callback) {
    }
}

