/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http3.parser.ControlParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlStreamConnection
extends AbstractConnection
implements Connection.UpgradeTo {
    public static final long STREAM_TYPE = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ControlStreamConnection.class);
    private final ByteBufferPool bufferPool;
    private final ControlParser parser;
    private boolean useInputDirectByteBuffers = true;
    private RetainableByteBuffer buffer;

    public ControlStreamConnection(EndPoint endPoint, Executor executor, ByteBufferPool bufferPool, ControlParser parser) {
        super(endPoint, executor);
        this.bufferPool = bufferPool;
        this.parser = parser;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public void onUpgradeTo(ByteBuffer upgrade) {
        int capacity = Math.max(upgrade.remaining(), this.getInputBufferSize());
        this.buffer = this.bufferPool.acquire(capacity, this.isUseInputDirectByteBuffers());
        ByteBuffer byteBuffer = this.buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        byteBuffer.put(upgrade);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
    }

    public void onOpen() {
        super.onOpen();
        if (this.buffer != null && this.buffer.hasRemaining()) {
            this.onFillable();
        } else {
            this.fillInterested();
        }
    }

    public void onFillable() {
        block6: {
            try {
                int filled;
                if (this.buffer == null) {
                    this.buffer = this.bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
                }
                ByteBuffer byteBuffer = this.buffer.getByteBuffer();
                do {
                    this.parser.parse(byteBuffer);
                    filled = this.getEndPoint().fill(byteBuffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("filled {} on {}", (Object)filled, (Object)this);
                    }
                    if (filled != 0) continue;
                    this.buffer.release();
                    this.buffer = null;
                    this.fillInterested();
                    break block6;
                } while (filled >= 0);
                this.buffer.release();
                this.buffer = null;
                this.getEndPoint().close();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("could not process control stream {}", (Object)this.getEndPoint(), (Object)x);
                }
                this.buffer.release();
                this.buffer = null;
                this.getEndPoint().close(x);
            }
        }
    }
}

