/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.util.Map;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.client.internal.ClientHTTP3Session;
import org.eclipse.jetty.http3.client.internal.ClientHTTP3StreamConnection;
import org.eclipse.jetty.http3.parser.MessageParser;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3ClientConnectionFactory
implements ClientConnectionFactory,
ProtocolSession.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3ClientConnectionFactory.class);

    public ProtocolSession newProtocolSession(Session quicSession, Map<String, Object> context) {
        HTTP3Client client = (HTTP3Client)context.get(HTTP3Client.CONTEXT_KEY);
        ClientHTTP3Session h3Session = new ClientHTTP3Session(client.getClientConnector(), client.getHTTP3Configuration(), quicSession, this, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created protocol-specific {}", (Object)h3Session);
        }
        return h3Session;
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        StreamEndPoint streamEndPoint = (StreamEndPoint)endPoint;
        long streamId = streamEndPoint.getStream().getId();
        ClientHTTP3Session http3Session = (ClientHTTP3Session)streamEndPoint.getProtocolSession();
        MessageParser parser = new MessageParser(http3Session.getSessionClient().getParserListener(), http3Session.getQpackDecoder(), streamId);
        ClientHTTP3StreamConnection connection = new ClientHTTP3StreamConnection(streamEndPoint, http3Session, parser);
        return this.customize((Connection)connection, context);
    }
}

