/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.net.SocketAddress;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.quic.client.ClientQuicConfiguration;
import org.eclipse.jetty.quic.common.SessionContainer;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3Client
extends ContainerLifeCycle
implements AutoCloseable {
    public static final String CONTEXT_KEY = HTTP3Client.class.getName();
    public static final String SESSION_PROMISE_CONTEXT_KEY = Session.Client.class.getName() + ".promise";
    public static final String SESSION_LISTENER_CONTEXT_KEY = Session.Client.Listener.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Client.class);
    private final SessionContainer container = new SessionContainer();
    private final HTTP3Configuration http3Configuration = new HTTP3Configuration();
    private final ClientQuicConfiguration quicConfiguration;
    private final ClientConnector connector;
    private List<String> protocols = List.of("h3");
    private boolean useALPN = true;

    public HTTP3Client(ClientQuicConfiguration quicConfiguration) {
        this(quicConfiguration, new ClientConnector());
    }

    public HTTP3Client(ClientQuicConfiguration quicConfiguration, ClientConnector connector) {
        this.quicConfiguration = quicConfiguration;
        this.connector = connector;
        this.installBean(connector);
    }

    public HTTP3Configuration getHTTP3Configuration() {
        return this.http3Configuration;
    }

    public ClientQuicConfiguration getClientQuicConfiguration() {
        return this.quicConfiguration;
    }

    public ClientConnector getClientConnector() {
        return this.connector;
    }

    public List<String> getApplicationProtocols() {
        return this.protocols;
    }

    public void setApplicationProtocols(List<String> protocols) {
        this.protocols = List.copyOf(protocols);
    }

    public boolean isUseALPN() {
        return this.useALPN;
    }

    public void setUseALPN(boolean useALPN) {
        this.useALPN = useALPN;
    }

    protected void doStart() throws Exception {
        LOG.info("HTTP/3+QUIC support is experimental and not suited for production use.");
        this.addBean(this.quicConfiguration);
        this.addBean(this.container);
        this.addBean(this.http3Configuration);
        this.quicConfiguration.addEventListener((EventListener)this.container);
        super.doStart();
    }

    public void connect(Transport transport, SocketAddress socketAddress, Session.Client.Listener listener, Promise.Invocable<Session.Client> promise) {
        this.connect(transport, this.getClientConnector().getSslContextFactory(), socketAddress, listener, promise);
    }

    public void connect(Transport transport, SslContextFactory.Client sslContextFactory, SocketAddress socketAddress, Session.Client.Listener listener, Promise.Invocable<Session.Client> promise) {
        this.connect(transport, sslContextFactory, socketAddress, listener, null, promise);
    }

    public void connect(Transport transport, SslContextFactory.Client sslContextFactory, SocketAddress socketAddress, Session.Client.Listener listener, Map<String, Object> context, Promise.Invocable<Session.Client> promise) {
        if (context == null) {
            context = new ConcurrentHashMap<String, Object>();
        }
        context.put(CONTEXT_KEY, this);
        context.put(SESSION_LISTENER_CONTEXT_KEY, listener);
        context.put(SESSION_PROMISE_CONTEXT_KEY, promise);
        context.put(ClientConnector.CONTEXT_KEY, this.getClientConnector());
        context.put(ClientConnector.APPLICATION_PROTOCOLS_CONTEXT_KEY, this.getApplicationProtocols());
        context.computeIfAbsent(ClientConnector.SSL_CONTEXT_FACTORY_CONTEXT_KEY, key -> sslContextFactory);
        context.put(ClientConnector.CONNECTION_PROMISE_CONTEXT_KEY, Promise.from(ioConnection -> {}, arg_0 -> promise.failed(arg_0)));
        context.put(ClientConnectionFactory.CONTEXT_KEY, this.resolveClientConnectionFactory(transport, sslContextFactory, context));
        context.put(Transport.CONTEXT_KEY, transport);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to {}", (Object)socketAddress);
        }
        transport.connect(socketAddress, context);
    }

    public CompletableFuture<Void> shutdown() {
        return this.container.shutdown().whenComplete((r, x) -> LifeCycle.stop((Object)this));
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    private ClientConnectionFactory resolveClientConnectionFactory(Transport transport, SslContextFactory.Client sslContextFactory, Map<String, Object> context) {
        ClientConnectionFactory.Decorator decorator;
        ClientConnectionFactory factory = (ClientConnectionFactory)context.get(ClientConnectionFactory.CONTEXT_KEY);
        if (factory == null) {
            factory = new HTTP3ClientConnectionFactory();
        }
        ClientConnector clientConnector = this.getClientConnector();
        factory = transport.newClientConnectionFactory(clientConnector, factory);
        if (sslContextFactory != null && !transport.isIntrinsicallySecure()) {
            List applicationProtocols = (List)context.get(ClientConnector.APPLICATION_PROTOCOLS_CONTEXT_KEY);
            if (this.isUseALPN() && !applicationProtocols.isEmpty()) {
                factory = new ALPNClientConnectionFactory(clientConnector.getExecutor(), factory, applicationProtocols);
            }
            factory = clientConnector.newSslClientConnectionFactory(sslContextFactory, factory);
        }
        if ((decorator = (ClientConnectionFactory.Decorator)context.get(ClientConnectionFactory.Decorator.CONTEXT_KEY)) != null) {
            factory = decorator.apply(factory);
        }
        return factory;
    }
}

