/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Exception;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.internal.ClientHTTP3Session;
import org.eclipse.jetty.http3.client.internal.HTTP3StreamClient;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.ProtocolStreamListener;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3SessionClient
extends HTTP3Session
implements Session.Client {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3SessionClient.class);
    private final Promise.Invocable<Session.Client> promise;

    public HTTP3SessionClient(Scheduler scheduler, ClientHTTP3Session session, Session.Client.Listener listener, Promise.Invocable<Session.Client> promise) {
        super(scheduler, (ProtocolSession)session, (Session.Listener)listener);
        this.promise = promise;
    }

    public ClientHTTP3Session getProtocolSession() {
        return (ClientHTTP3Session)super.getProtocolSession();
    }

    public void onOpen() {
        super.onOpen();
        if (this.promise != null) {
            this.promise.succeeded((Object)this);
        }
    }

    protected HTTP3StreamClient newHTTP3Stream(StreamEndPoint endPoint, boolean local) {
        return new HTTP3StreamClient(this, endPoint, local);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
        if (frame.getMetaData().isResponse()) {
            StreamEndPoint endPoint = this.getProtocolSession().getStreamEndPoint(streamId);
            HTTP3StreamClient stream = (HTTP3StreamClient)this.getStream(endPoint.getStream().getId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("received response {} on {}", (Object)frame, (Object)stream);
            }
            if (stream == null) throw new HTTP3Exception.StreamException(HTTP3ErrorCode.REQUEST_REJECTED_ERROR, "missing_http3_stream");
            stream.onResponse(frame);
            return;
        } else {
            super.onHeaders(streamId, frame, wasBlocked);
        }
    }

    public void onSettings(SettingsFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("received {} on {}", (Object)frame, (Object)this);
        }
        this.getProtocolSession().onSettings(frame);
        super.onSettings(frame);
    }

    public void newRequest(final HeadersFrame frame, Stream.Client.Listener listener, final Promise.Invocable<org.eclipse.jetty.http3.api.Stream> promise) {
        HTTP3StreamClient stream;
        ClientHTTP3Session protocolSession = this.getProtocolSession();
        Session quicSession = protocolSession.getSession();
        long streamId = quicSession.newStreamId(true);
        AtomicReference<StreamEndPoint> endPointRef = new AtomicReference<StreamEndPoint>();
        Stream quicStream = quicSession.newStream(streamId, (Stream.Listener)new ProtocolStreamListener.Client(endPointRef::get));
        StreamEndPoint endPoint = protocolSession.createStreamEndPoint(quicStream, arg_0 -> ((ClientHTTP3Session)protocolSession).openStreamEndPoint(arg_0));
        endPointRef.set(endPoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("new request {} with {} on {}", new Object[]{quicStream, frame, this});
        }
        try {
            stream = (HTTP3StreamClient)this.createStream(endPoint);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not create stream for {} on {}", new Object[]{endPoint, this, x});
            }
            Promise.Invocable p = Promise.Invocable.from((Invocable.InvocationType)promise.getInvocationType(), s -> promise.failed(x), t -> promise.failed(x));
            endPoint.disconnect(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x, true, p);
            return;
        }
        stream.setListener(listener);
        stream.onOpen();
        stream.writeFrame((Frame)frame, (Promise.Invocable)new Promise.Invocable.Abstract<org.eclipse.jetty.http3.api.Stream>(this, promise.getInvocationType()){
            final /* synthetic */ HTTP3SessionClient this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public void succeeded(org.eclipse.jetty.http3.api.Stream result) {
                stream.updateClose(frame.isLast(), true);
                promise.succeeded((Object)result);
            }

            public void failed(Throwable x) {
                stream.updateClose(frame.isLast(), true);
                Promise.Invocable p = Promise.Invocable.from((Invocable.InvocationType)this.getInvocationType(), s -> promise.failed(x), t -> promise.failed(x));
                stream.disconnect(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x, p);
            }
        });
    }

    public void writeControlFrame(Frame frame, Callback callback) {
        this.getProtocolSession().writeControlFrame(frame, callback);
    }

    public void writeMessageFrame(StreamEndPoint streamEndPoint, Frame frame, Callback callback) {
        this.getProtocolSession().writeMessageFrame(streamEndPoint, frame, callback);
    }

    protected GoAwayFrame newGoAwayFrame(boolean graceful) {
        if (graceful) {
            return GoAwayFrame.CLIENT_GRACEFUL;
        }
        return super.newGoAwayFrame(graceful);
    }
}

