/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.io.IOException;
import java.util.function.Consumer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3Stream;
import org.eclipse.jetty.http3.server.internal.HttpTransportOverHTTP3;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3StreamConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverHTTP3
extends HttpChannel {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverHTTP3.class);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private final AutoLock lock = new AutoLock();
    private final HTTP3Stream stream;
    private final ServerHTTP3StreamConnection connection;
    private HttpInput.Content content;
    private boolean expect100Continue;
    private boolean delayedUntilContent;

    public HttpChannelOverHTTP3(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP3 transport, HTTP3Stream stream, ServerHTTP3StreamConnection connection) {
        super(connector, configuration, endPoint, (HttpTransport)transport);
        this.stream = stream;
        this.connection = connection;
    }

    public HttpTransportOverHTTP3 getHttpTransport() {
        return (HttpTransportOverHTTP3)super.getHttpTransport();
    }

    public void setIdleTimeout(long timeoutMs) {
        this.stream.setIdleTimeout(timeoutMs);
    }

    void consumeInput() {
        this.getRequest().getHttpInput().consumeAll();
    }

    public boolean isExpecting100Continue() {
        return this.expect100Continue;
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this.expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            MetaData.Request request = (MetaData.Request)frame.getMetaData();
            HttpFields fields = request.getFields();
            this.expect100Continue = fields.contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            HttpFields.Mutable response = this.getResponse().getHttpFields();
            if (this.getHttpConfiguration().getSendServerVersion()) {
                response.add(SERVER_VERSION);
            }
            if (this.getHttpConfiguration().getSendXPoweredBy()) {
                response.add(POWERED_BY);
            }
            this.onRequest(request);
            boolean endStream = frame.isLast();
            if (endStream) {
                this.onContentComplete();
                this.onRequestComplete();
            }
            boolean connect = request instanceof MetaData.ConnectRequest;
            boolean bl = this.delayedUntilContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && !endStream && !this.expect100Continue && !connect;
            if (connect) {
                if (request.getProtocol() == null) {
                    this.stream.demand();
                }
            } else if (this.delayedUntilContent) {
                this.stream.demand();
            } else {
                this.connection.setApplicationMode(true);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 request #{}/{}, delayed={}:{}{} {} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), this.delayedUntilContent, System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), fields});
            }
            return this.delayedUntilContent ? null : this;
        }
        catch (BadMessageException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onRequest() failure", (Throwable)x);
            }
            this.onBadMessage(x);
            return null;
        }
        catch (Throwable x) {
            this.onBadMessage(new BadMessageException(500, null, x));
            return null;
        }
    }

    protected void commit(MetaData.Response info) {
        super.commit(info);
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 commit response #{}/{}:{}{} {} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), info.getHttpVersion(), info.getStatus(), info.getReason(), System.lineSeparator(), info.getFields()});
        }
    }

    public Runnable onDataAvailable() {
        boolean woken = this.getRequest().getHttpInput().onContentProducible();
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 request data available #{}/{} woken: {}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), woken});
        }
        boolean wasDelayed = this.delayedUntilContent;
        this.delayedUntilContent = false;
        if (wasDelayed) {
            this.connection.setApplicationMode(true);
        }
        return wasDelayed || woken ? this : null;
    }

    public Runnable onTrailer(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getFields();
        if (trailers.size() > 0) {
            this.onTrailers(trailers);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Request #{}/{}, trailers:{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        boolean handle = this.onRequestComplete();
        boolean woken = this.getRequest().getHttpInput().onContentProducible();
        handle |= woken;
        boolean wasDelayed = this.delayedUntilContent;
        this.delayedUntilContent = false;
        if (wasDelayed) {
            this.connection.setApplicationMode(true);
        }
        return wasDelayed || handle ? this : null;
    }

    public boolean onIdleTimeout(Throwable failure, Consumer<Runnable> consumer) {
        boolean wasDelayed = this.delayedUntilContent;
        this.delayedUntilContent = false;
        if (wasDelayed) {
            this.connection.setApplicationMode(true);
        }
        this.getHttpTransport().onIdleTimeout(failure);
        boolean neverDispatched = this.getState().isIdle();
        boolean hasDemand = this.stream.hasDemand();
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 request idle timeout #{}/{}, dispatched={} demand={}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), !neverDispatched, hasDemand});
        }
        if (neverDispatched) {
            try (AutoLock l = this.lock.lock();){
                this.content = new HttpInput.ErrorContent(failure);
            }
            consumer.accept(this::handleWithContext);
        } else if (hasDemand) {
            try (AutoLock l = this.lock.lock();){
                this.content = new HttpInput.ErrorContent(failure);
            }
            if (this.getRequest().getHttpInput().onContentProducible()) {
                consumer.accept(this::handleWithContext);
            }
        }
        return false;
    }

    private void handleWithContext() {
        ContextHandler context = this.getState().getContextHandler();
        if (context != null) {
            context.handle(this.getRequest(), (Runnable)((Object)this));
        } else {
            this.handle();
        }
    }

    public Runnable onFailure(Throwable failure) {
        this.consumeInput();
        this.getHttpTransport().onFailure(failure);
        boolean handle = this.failed(failure);
        return () -> {
            if (handle) {
                this.handleWithContext();
            } else if (this.getHttpConfiguration().isNotifyRemoteAsyncErrors()) {
                this.getState().asyncError(failure);
            }
        };
    }

    public boolean needContent() {
        try (AutoLock l = this.lock.lock();){
            if (this.content != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("need content has immediate content {} on {}", (Object)this.content, (Object)this);
                }
                boolean bl = true;
                return bl;
            }
        }
        HttpInput.Content result = this.readContent();
        if (result != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("need content read content {} on {}", (Object)this.content, (Object)this);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("need content demanding content on {}", (Object)this);
        }
        this.stream.demand();
        return false;
    }

    public HttpInput.Content produceContent() {
        HttpInput.Content result;
        try (AutoLock l = this.lock.lock();){
            result = this.content;
        }
        if (result == null) {
            result = this.readContent();
        }
        if (result == null) {
            return null;
        }
        if (!result.isSpecial()) {
            HttpInput.EofContent newContent = result.isEof() ? new HttpInput.EofContent() : null;
            try (AutoLock l = this.lock.lock();){
                this.content = newContent;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("produced content {} on {}", (Object)result, (Object)this);
        }
        return result;
    }

    private HttpInput.Content readContent() {
        Stream.Data data = this.stream.readData();
        if (LOG.isDebugEnabled()) {
            LOG.debug("read data {} on {}", (Object)data, (Object)this);
        }
        if (data != null) {
            HttpInput.Content result = this.newContent(data);
            boolean handle = this.onContent(result);
            try (AutoLock l = this.lock.lock();){
                if (LOG.isDebugEnabled()) {
                    LOG.debug("read content {} on {}", (Object)result, (Object)this);
                }
                this.content = result;
            }
            if (data.isLast()) {
                boolean handleContent = this.onContentComplete();
                boolean handleRequest = this.onRequestComplete();
                handle |= handleContent | handleRequest;
            }
            return result;
        }
        try (AutoLock l = this.lock.lock();){
            HttpInput.Content content = this.content;
            return content;
        }
    }

    private HttpInput.Content newContent(Stream.Data data) {
        return new DataContent(data);
    }

    public boolean failAllContent(Throwable failure) {
        HttpInput.Content result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("failing all content with {} {}", (Object)failure, (Object)this);
        }
        try (AutoLock l = this.lock.lock();){
            result = this.content;
            if (result == null) {
                boolean bl = false;
                return bl;
            }
            if (result.isSpecial()) {
                boolean bl = result.isEof();
                return bl;
            }
            this.content = null;
        }
        result.failed(failure);
        return false;
    }

    public boolean failed(Throwable failure) {
        HttpInput.Content contentToFail = null;
        try (AutoLock l = this.lock.lock();){
            if (this.content == null) {
                this.content = new HttpInput.ErrorContent(failure);
            } else if (this.content.isSpecial()) {
            } else {
                contentToFail = this.content;
                this.content = new HttpInput.ErrorContent(failure);
            }
        }
        if (contentToFail != null) {
            contentToFail.failed(failure);
        }
        return this.getRequest().getHttpInput().onContentProducible();
    }

    protected boolean eof() {
        try (AutoLock l = this.lock.lock();){
            if (this.content == null) {
                this.content = new HttpInput.EofContent();
            } else if (!this.content.isEof()) {
                if (this.content.remaining() == 0) {
                    this.content = new HttpInput.EofContent();
                } else {
                    throw new IllegalStateException();
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    private static class DataContent
    extends HttpInput.Content {
        private final Stream.Data data;

        public DataContent(Stream.Data data) {
            super(data.getByteBuffer());
            this.data = data;
        }

        public boolean isEof() {
            return this.data.isLast();
        }

        public void succeeded() {
            this.data.complete();
        }

        public void failed(Throwable x) {
            this.data.complete();
        }
    }
}

