/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.http3.qpack.internal.util.EncodingException;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerParser;
import org.eclipse.jetty.http3.qpack.internal.util.NBitStringParser;

public class DecoderInstructionParser {
    private final Handler _handler;
    private final NBitStringParser _stringParser;
    private final NBitIntegerParser _integerParser;
    private State _state = State.PARSING;
    private Operation _operation = Operation.NONE;
    private boolean _referenceDynamicTable;
    private int _index;
    private String _name;

    public DecoderInstructionParser(Handler handler) {
        this._handler = handler;
        this._stringParser = new NBitStringParser();
        this._integerParser = new NBitIntegerParser();
    }

    public void parse(ByteBuffer buffer) throws QpackException, EncodingException {
        if (buffer == null || !buffer.hasRemaining()) {
            return;
        }
        switch (this._state) {
            case PARSING: {
                byte firstByte = buffer.get(buffer.position());
                if ((firstByte & 0x80) != 0) {
                    this._state = State.REFERENCED_NAME;
                    this.parseInsertNameWithReference(buffer);
                    break;
                }
                if ((firstByte & 0x40) != 0) {
                    this._state = State.LITERAL_NAME;
                    this.parseInsertWithLiteralName(buffer);
                    break;
                }
                if ((firstByte & 0x20) != 0) {
                    this._state = State.SET_CAPACITY;
                    this._integerParser.setPrefix(5);
                    this.parseSetDynamicTableCapacity(buffer);
                    break;
                }
                this._state = State.DUPLICATE;
                this._integerParser.setPrefix(5);
                this.parseDuplicate(buffer);
                break;
            }
            case SET_CAPACITY: {
                this.parseSetDynamicTableCapacity(buffer);
                break;
            }
            case DUPLICATE: {
                this.parseDuplicate(buffer);
                break;
            }
            case LITERAL_NAME: {
                this.parseInsertWithLiteralName(buffer);
                break;
            }
            case REFERENCED_NAME: {
                this.parseInsertNameWithReference(buffer);
                break;
            }
            default: {
                throw new IllegalStateException(this._state.name());
            }
        }
    }

    private void parseInsertNameWithReference(ByteBuffer buffer) throws QpackException, EncodingException {
        block5: while (true) {
            switch (this._operation) {
                case NONE: {
                    byte firstByte = buffer.get(buffer.position());
                    this._referenceDynamicTable = (firstByte & 0x40) == 0;
                    this._operation = Operation.INDEX;
                    this._integerParser.setPrefix(6);
                    continue block5;
                }
                case INDEX: {
                    this._index = this._integerParser.decodeInt(buffer);
                    if (this._index < 0) {
                        return;
                    }
                    this._operation = Operation.VALUE;
                    this._stringParser.setPrefix(8);
                    continue block5;
                }
                case VALUE: {
                    String value = this._stringParser.decode(buffer);
                    if (value == null) {
                        return;
                    }
                    int index = this._index;
                    boolean dynamic = this._referenceDynamicTable;
                    this.reset();
                    this._handler.onInsertNameWithReference(index, dynamic, value);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._operation.name());
    }

    private void parseInsertWithLiteralName(ByteBuffer buffer) throws QpackException, EncodingException {
        block5: while (true) {
            switch (this._operation) {
                case NONE: {
                    this._operation = Operation.NAME;
                    this._stringParser.setPrefix(6);
                    continue block5;
                }
                case NAME: {
                    this._name = this._stringParser.decode(buffer);
                    if (this._name == null) {
                        return;
                    }
                    this._operation = Operation.VALUE;
                    this._stringParser.setPrefix(8);
                    continue block5;
                }
                case VALUE: {
                    String value = this._stringParser.decode(buffer);
                    if (value == null) {
                        return;
                    }
                    String name = this._name;
                    this.reset();
                    this._handler.onInsertWithLiteralName(name, value);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._operation.name());
    }

    private void parseDuplicate(ByteBuffer buffer) throws QpackException {
        int index = this._integerParser.decodeInt(buffer);
        if (index >= 0) {
            this.reset();
            this._handler.onDuplicate(index);
        }
    }

    private void parseSetDynamicTableCapacity(ByteBuffer buffer) throws QpackException {
        int capacity = this._integerParser.decodeInt(buffer);
        if (capacity >= 0) {
            this.reset();
            this._handler.onSetDynamicTableCapacity(capacity);
        }
    }

    public void reset() {
        this._stringParser.reset();
        this._integerParser.reset();
        this._state = State.PARSING;
        this._operation = Operation.NONE;
        this._referenceDynamicTable = false;
        this._index = -1;
        this._name = null;
    }

    public static interface Handler {
        public void onSetDynamicTableCapacity(int var1) throws QpackException;

        public void onDuplicate(int var1) throws QpackException;

        public void onInsertNameWithReference(int var1, boolean var2, String var3) throws QpackException;

        public void onInsertWithLiteralName(String var1, String var2) throws QpackException;
    }

    private static enum Operation {
        NONE,
        INDEX,
        NAME,
        VALUE;

    }

    private static enum State {
        PARSING,
        SET_CAPACITY,
        REFERENCED_NAME,
        LITERAL_NAME,
        DUPLICATE;

    }
}

