/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class StreamCancellationInstruction
implements Instruction {
    private final long _streamId;

    public StreamCancellationInstruction(long streamId) {
        this._streamId = streamId;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = NBitIntegerEncoder.octectsNeeded(6, this._streamId) + 1;
        ByteBuffer buffer = lease.acquire(size, false);
        buffer.put((byte)64);
        NBitIntegerEncoder.encode(buffer, 6, this._streamId);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

