/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;
import org.eclipse.jetty.http3.qpack.internal.util.HuffmanEncoder;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;

public abstract class EncodableEntry {
    public static EncodableEntry getReferencedEntry(Entry entry) {
        return new ReferencedEntry(entry);
    }

    public static EncodableEntry getNameReferencedEntry(Entry nameEntry, HttpField field, boolean huffman) {
        return new ReferencedNameEntry(nameEntry, field, huffman);
    }

    public static EncodableEntry getLiteralEntry(HttpField field, boolean huffman) {
        return new LiteralEntry(field, huffman);
    }

    public static EncodableEntry getPreEncodedEntry(PreEncodedHttpField httpField) {
        return new PreEncodedEntry(httpField);
    }

    public abstract void encode(ByteBuffer var1, int var2);

    public abstract int getRequiredSize(int var1);

    public abstract int getRequiredInsertCount();

    private static class PreEncodedEntry
    extends EncodableEntry {
        private final PreEncodedHttpField _httpField;

        public PreEncodedEntry(PreEncodedHttpField httpField) {
            this._httpField = httpField;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            this._httpField.putTo(buffer, HttpVersion.HTTP_3);
        }

        @Override
        public int getRequiredSize(int base) {
            return this._httpField.getEncodedLength(HttpVersion.HTTP_3);
        }

        @Override
        public int getRequiredInsertCount() {
            return 0;
        }
    }

    private static class LiteralEntry
    extends EncodableEntry {
        private final HttpField _field;
        private final boolean _huffman;

        public LiteralEntry(HttpField field, boolean huffman) {
            this._field = field;
            this._huffman = huffman;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            int allowIntermediary = 0;
            String name = this.getName();
            String value = this.getValue();
            if (this._huffman) {
                buffer.put((byte)(0x28 | allowIntermediary));
                NBitIntegerEncoder.encode(buffer, 3, HuffmanEncoder.octetsNeeded(name));
                HuffmanEncoder.encode(buffer, name);
                buffer.put((byte)-128);
                NBitIntegerEncoder.encode(buffer, 7, HuffmanEncoder.octetsNeeded(value));
                HuffmanEncoder.encode(buffer, value);
            } else {
                buffer.put((byte)(0x20 | allowIntermediary));
                NBitIntegerEncoder.encode(buffer, 3, name.length());
                buffer.put(name.getBytes());
                buffer.put((byte)0);
                NBitIntegerEncoder.encode(buffer, 7, value.length());
                buffer.put(value.getBytes());
            }
        }

        @Override
        public int getRequiredSize(int base) {
            String name = this.getName();
            String value = this.getValue();
            int nameLength = this._huffman ? HuffmanEncoder.octetsNeeded(name) : name.length();
            int valueLength = this._huffman ? HuffmanEncoder.octetsNeeded(value) : value.length();
            return 2 + NBitIntegerEncoder.octectsNeeded(3, nameLength) + nameLength + NBitIntegerEncoder.octectsNeeded(7, valueLength) + valueLength;
        }

        @Override
        public int getRequiredInsertCount() {
            return 0;
        }

        private String getName() {
            String name = Objects.requireNonNull(this._field).getName();
            return name == null ? "" : name;
        }

        private String getValue() {
            String value = Objects.requireNonNull(this._field).getValue();
            return value == null ? "" : value;
        }
    }

    private static class ReferencedNameEntry
    extends EncodableEntry {
        private final Entry _nameEntry;
        private final HttpField _field;
        private final boolean _huffman;

        public ReferencedNameEntry(Entry nameEntry, HttpField field, boolean huffman) {
            this._nameEntry = nameEntry;
            this._field = field;
            this._huffman = huffman;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            int relativeIndex;
            boolean allowIntermediary = false;
            boolean isStatic = this._nameEntry.isStatic();
            if (isStatic) {
                buffer.put((byte)(0x50 | (allowIntermediary ? 32 : 0)));
                relativeIndex = this._nameEntry.getIndex();
                NBitIntegerEncoder.encode(buffer, 4, relativeIndex);
            } else if (this._nameEntry.getIndex() < base) {
                buffer.put((byte)(0x40 | (allowIntermediary ? 32 : 0)));
                relativeIndex = base - (this._nameEntry.getIndex() + 1);
                NBitIntegerEncoder.encode(buffer, 4, relativeIndex);
            } else {
                buffer.put((byte)(allowIntermediary ? 8 : 0));
                relativeIndex = this._nameEntry.getIndex() - base;
                NBitIntegerEncoder.encode(buffer, 3, relativeIndex);
            }
            String value = this.getValue();
            if (this._huffman) {
                buffer.put((byte)-128);
                NBitIntegerEncoder.encode(buffer, 7, HuffmanEncoder.octetsNeeded(value));
                HuffmanEncoder.encode(buffer, value);
            } else {
                buffer.put((byte)0);
                NBitIntegerEncoder.encode(buffer, 7, value.length());
                buffer.put(value.getBytes());
            }
        }

        @Override
        public int getRequiredSize(int base) {
            String value = this.getValue();
            int relativeIndex = this._nameEntry.getIndex() - base;
            int valueLength = this._huffman ? HuffmanEncoder.octetsNeeded(value) : value.length();
            return 1 + NBitIntegerEncoder.octectsNeeded(4, relativeIndex) + 1 + NBitIntegerEncoder.octectsNeeded(7, valueLength) + valueLength;
        }

        @Override
        public int getRequiredInsertCount() {
            return this._nameEntry.isStatic() ? 0 : this._nameEntry.getIndex() + 1;
        }

        private String getValue() {
            String value = Objects.requireNonNull(this._field).getValue();
            return value == null ? "" : value;
        }
    }

    private static class ReferencedEntry
    extends EncodableEntry {
        private final Entry _entry;

        public ReferencedEntry(Entry entry) {
            this._entry = entry;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            boolean isStatic = this._entry.isStatic();
            if (isStatic) {
                buffer.put((byte)-64);
                int relativeIndex = this._entry.getIndex();
                NBitIntegerEncoder.encode(buffer, 6, relativeIndex);
            } else if (this._entry.getIndex() < base) {
                buffer.put((byte)-128);
                int relativeIndex = base - (this._entry.getIndex() + 1);
                NBitIntegerEncoder.encode(buffer, 6, relativeIndex);
            } else {
                buffer.put((byte)16);
                int relativeIndex = this._entry.getIndex() - base;
                NBitIntegerEncoder.encode(buffer, 4, relativeIndex);
            }
        }

        @Override
        public int getRequiredSize(int base) {
            boolean isStatic = this._entry.isStatic();
            if (isStatic) {
                int relativeIndex = this._entry.getIndex();
                return 1 + NBitIntegerEncoder.octectsNeeded(6, relativeIndex);
            }
            if (this._entry.getIndex() < base) {
                int relativeIndex = base - (this._entry.getIndex() + 1);
                return 1 + NBitIntegerEncoder.octectsNeeded(6, relativeIndex);
            }
            int relativeIndex = this._entry.getIndex() - base;
            return 1 + NBitIntegerEncoder.octectsNeeded(4, relativeIndex);
        }

        @Override
        public int getRequiredInsertCount() {
            return this._entry.isStatic() ? 0 : this._entry.getIndex() + 1;
        }
    }
}

