/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.internal.util.HuffmanEncoder;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class IndexedNameEntryInstruction
implements Instruction {
    private final boolean _dynamic;
    private final int _index;
    private final boolean _huffman;
    private final String _value;

    public IndexedNameEntryInstruction(boolean dynamic, int index, boolean huffman, String value) {
        this._dynamic = dynamic;
        this._index = index;
        this._huffman = huffman;
        this._value = value;
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public int getIndex() {
        return this._index;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = NBitIntegerEncoder.octectsNeeded(6, this._index) + (this._huffman ? HuffmanEncoder.octetsNeeded(this._value) : this._value.length()) + 2;
        ByteBuffer buffer = lease.acquire(size, false);
        buffer.put((byte)(0x80 | (this._dynamic ? 0 : 64)));
        NBitIntegerEncoder.encode(buffer, 6, this._index);
        if (this._huffman) {
            buffer.put((byte)-128);
            NBitIntegerEncoder.encode(buffer, 7, HuffmanEncoder.octetsNeeded(this._value));
            HuffmanEncoder.encode(buffer, this._value);
        } else {
            buffer.put((byte)0);
            NBitIntegerEncoder.encode(buffer, 7, this._value.length());
            buffer.put(this._value.getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

