/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class InsertCountIncrementInstruction
implements Instruction {
    private final int _increment;

    public InsertCountIncrementInstruction(int increment) {
        this._increment = increment;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = NBitIntegerEncoder.octectsNeeded(6, this._increment) + 1;
        ByteBuffer buffer = lease.acquire(size, false);
        buffer.put((byte)0);
        NBitIntegerEncoder.encode(buffer, 6, this._increment);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

