/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;

public class StreamInfo
implements Iterable<SectionInfo> {
    private final long _streamId;
    private final Queue<SectionInfo> _sectionInfos = new LinkedList<SectionInfo>();

    public StreamInfo(long streamId) {
        this._streamId = streamId;
    }

    public long getStreamId() {
        return this._streamId;
    }

    public void add(SectionInfo sectionInfo) {
        this._sectionInfos.add(sectionInfo);
    }

    public void remove(SectionInfo sectionInfo) {
        this._sectionInfos.remove(sectionInfo);
    }

    public SectionInfo getCurrentSectionInfo() {
        return this._sectionInfos.peek();
    }

    public SectionInfo acknowledge() {
        return this._sectionInfos.poll();
    }

    public boolean isEmpty() {
        return this._sectionInfos.isEmpty();
    }

    public boolean isBlocked() {
        for (SectionInfo info : this._sectionInfos) {
            if (!info.isBlocking()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<SectionInfo> iterator() {
        return this._sectionInfos.iterator();
    }

    public static class SectionInfo {
        private final List<Entry> _entries = new ArrayList<Entry>();
        private int _requiredInsertCount;
        private boolean _block = false;

        public void block() {
            this._block = true;
        }

        public boolean isBlocking() {
            return this._block;
        }

        public void reference(Entry entry) {
            entry.reference();
            this._entries.add(entry);
        }

        public void release() {
            for (Entry entry : this._entries) {
                entry.release();
            }
            this._entries.clear();
        }

        public void setRequiredInsertCount(int requiredInsertCount) {
            this._requiredInsertCount = requiredInsertCount;
        }

        public int getRequiredInsertCount() {
            return this._requiredInsertCount;
        }
    }
}

