/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.http3.qpack.internal.QpackContext;
import org.eclipse.jetty.http3.qpack.internal.instruction.InsertCountIncrementInstruction;
import org.eclipse.jetty.http3.qpack.internal.instruction.SectionAcknowledgmentInstruction;
import org.eclipse.jetty.http3.qpack.internal.instruction.StreamCancellationInstruction;
import org.eclipse.jetty.http3.qpack.internal.parser.DecoderInstructionParser;
import org.eclipse.jetty.http3.qpack.internal.parser.EncodedFieldSection;
import org.eclipse.jetty.http3.qpack.internal.table.DynamicTable;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;
import org.eclipse.jetty.http3.qpack.internal.table.StaticTable;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerParser;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpackDecoder
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(QpackDecoder.class);
    private final List<Instruction> _instructions = new ArrayList<Instruction>();
    private final List<MetaDataNotification> _metaDataNotifications = new ArrayList<MetaDataNotification>();
    private final Instruction.Handler _handler;
    private final QpackContext _context;
    private final DecoderInstructionParser _parser;
    private final List<EncodedFieldSection> _encodedFieldSections = new ArrayList<EncodedFieldSection>();
    private final NBitIntegerParser _integerDecoder = new NBitIntegerParser();
    private final InstructionHandler _instructionHandler = new InstructionHandler();
    private final int _maxHeaderSize;

    public QpackDecoder(Instruction.Handler handler, int maxHeaderSize) {
        this._context = new QpackContext();
        this._handler = handler;
        this._parser = new DecoderInstructionParser(this._instructionHandler);
        this._maxHeaderSize = maxHeaderSize;
    }

    QpackContext getQpackContext() {
        return this._context;
    }

    public boolean decode(long streamId, ByteBuffer buffer, Handler handler) throws QpackException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decoding: streamId={}, buffer={}", (Object)streamId, (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
        }
        if (buffer.remaining() > this._maxHeaderSize) {
            throw new QpackException.SessionException(512L, "header_too_large");
        }
        this._integerDecoder.setPrefix(8);
        int encodedInsertCount = this._integerDecoder.decodeInt(buffer);
        if (encodedInsertCount < 0) {
            throw new QpackException.SessionException(512L, "invalid_required_insert_count");
        }
        this._integerDecoder.setPrefix(7);
        boolean signBit = (buffer.get(buffer.position()) & 0x80) != 0;
        int deltaBase = this._integerDecoder.decodeInt(buffer);
        if (deltaBase < 0) {
            throw new QpackException.SessionException(512L, "invalid_delta_base");
        }
        DynamicTable dynamicTable = this._context.getDynamicTable();
        int insertCount = dynamicTable.getInsertCount();
        int maxDynamicTableSize = dynamicTable.getCapacity();
        int requiredInsertCount = QpackDecoder.decodeInsertCount(encodedInsertCount, insertCount, maxDynamicTableSize);
        try {
            int base = signBit ? requiredInsertCount - deltaBase - 1 : requiredInsertCount + deltaBase;
            EncodedFieldSection encodedFieldSection = new EncodedFieldSection(streamId, handler, requiredInsertCount, base, buffer);
            if (requiredInsertCount <= insertCount) {
                MetaData metaData = encodedFieldSection.decode(this._context, this._maxHeaderSize);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Decoded: streamId={}, metadata={}", (Object)streamId, (Object)metaData);
                }
                this._metaDataNotifications.add(new MetaDataNotification(streamId, metaData, handler));
                this._instructions.add(new SectionAcknowledgmentInstruction(streamId));
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deferred Decoding: streamId={}, encodedFieldSection={}", (Object)streamId, (Object)encodedFieldSection);
                }
                this._encodedFieldSections.add(encodedFieldSection);
            }
            boolean hadMetaData = !this._metaDataNotifications.isEmpty();
            this.notifyInstructionHandler();
            this.notifyMetaDataHandler();
            return hadMetaData;
        }
        catch (QpackException.SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new QpackException.SessionException(513L, t.getMessage(), t);
        }
    }

    public void parseInstructions(ByteBuffer buffer) throws QpackException {
        try {
            while (BufferUtil.hasContent((ByteBuffer)buffer)) {
                this._parser.parse(buffer);
            }
            this.notifyInstructionHandler();
            this.notifyMetaDataHandler();
        }
        catch (QpackException.SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new QpackException.SessionException(513L, t.getMessage(), t);
        }
    }

    public void streamCancellation(long streamId) {
        this._encodedFieldSections.removeIf(encodedFieldSection -> encodedFieldSection.getStreamId() == streamId);
        this._metaDataNotifications.removeIf(notification -> notification._streamId == streamId);
        this._instructions.add(new StreamCancellationInstruction(streamId));
        this.notifyInstructionHandler();
    }

    private void checkEncodedFieldSections() throws QpackException {
        int insertCount = this._context.getDynamicTable().getInsertCount();
        for (EncodedFieldSection encodedFieldSection : this._encodedFieldSections) {
            if (encodedFieldSection.getRequiredInsertCount() > insertCount) continue;
            long streamId = encodedFieldSection.getStreamId();
            MetaData metaData = encodedFieldSection.decode(this._context, this._maxHeaderSize);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decoded: streamId={}, metadata={}", (Object)streamId, (Object)metaData);
            }
            this._metaDataNotifications.add(new MetaDataNotification(streamId, metaData, encodedFieldSection.getHandler()));
            this._instructions.add(new SectionAcknowledgmentInstruction(streamId));
        }
    }

    private static int decodeInsertCount(int encInsertCount, int totalNumInserts, int maxTableCapacity) throws QpackException {
        if (encInsertCount == 0) {
            return 0;
        }
        int maxEntries = maxTableCapacity / 32;
        int fullRange = 2 * maxEntries;
        if (encInsertCount > fullRange) {
            throw new QpackException.SessionException(512L, "encInsertCount_greater_than_fullRange");
        }
        int maxValue = totalNumInserts + maxEntries;
        int maxWrapped = maxValue / fullRange * fullRange;
        int reqInsertCount = maxWrapped + encInsertCount - 1;
        if (reqInsertCount > maxValue) {
            if (reqInsertCount <= fullRange) {
                throw new QpackException.SessionException(512L, "reqInsertCount_less_than_or_equal_to_fullRange");
            }
            reqInsertCount -= fullRange;
        }
        if (reqInsertCount == 0) {
            throw new QpackException.SessionException(512L, "reqInsertCount_is_zero");
        }
        return reqInsertCount;
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this._context.getDynamicTable(), (Object[])new Object[0]);
    }

    public String toString() {
        return String.format("QpackDecoder@%x{%s}", this.hashCode(), this._context);
    }

    private void notifyInstructionHandler() {
        if (!this._instructions.isEmpty()) {
            this._handler.onInstructions(this._instructions);
        }
        this._instructions.clear();
    }

    private void notifyMetaDataHandler() {
        for (MetaDataNotification notification : this._metaDataNotifications) {
            notification.notifyHandler();
        }
        this._metaDataNotifications.clear();
    }

    InstructionHandler getInstructionHandler() {
        return this._instructionHandler;
    }

    class InstructionHandler
    implements DecoderInstructionParser.Handler {
        InstructionHandler() {
        }

        @Override
        public void onSetDynamicTableCapacity(int capacity) {
            QpackDecoder.this._context.getDynamicTable().setCapacity(capacity);
        }

        @Override
        public void onDuplicate(int index) throws QpackException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Duplicate: index={}", (Object)index);
            }
            DynamicTable dynamicTable = QpackDecoder.this._context.getDynamicTable();
            Entry referencedEntry = dynamicTable.get(index);
            Entry entry = new Entry(referencedEntry.getHttpField());
            dynamicTable.add(entry);
            QpackDecoder.this._instructions.add(new InsertCountIncrementInstruction(1));
            QpackDecoder.this.checkEncodedFieldSections();
        }

        @Override
        public void onInsertNameWithReference(int nameIndex, boolean isDynamicTableIndex, String value) throws QpackException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("InsertNameReference: nameIndex={}, dynamic={}, value={}", new Object[]{nameIndex, isDynamicTableIndex, value});
            }
            StaticTable staticTable = QpackContext.getStaticTable();
            DynamicTable dynamicTable = QpackDecoder.this._context.getDynamicTable();
            Entry referencedEntry = isDynamicTableIndex ? dynamicTable.get(nameIndex) : staticTable.get(nameIndex);
            Entry entry = new Entry(new HttpField(referencedEntry.getHttpField().getHeader(), referencedEntry.getHttpField().getName(), value));
            dynamicTable.add(entry);
            QpackDecoder.this._instructions.add(new InsertCountIncrementInstruction(1));
            QpackDecoder.this.checkEncodedFieldSections();
        }

        @Override
        public void onInsertWithLiteralName(String name, String value) throws QpackException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("InsertLiteralEntry: name={}, value={}", (Object)name, (Object)value);
            }
            Entry entry = new Entry(new HttpField(name, value));
            DynamicTable dynamicTable = QpackDecoder.this._context.getDynamicTable();
            dynamicTable.add(entry);
            QpackDecoder.this._instructions.add(new InsertCountIncrementInstruction(1));
            QpackDecoder.this.checkEncodedFieldSections();
        }
    }

    public static interface Handler {
        public void onMetaData(long var1, MetaData var3);
    }

    private static class MetaDataNotification {
        private final MetaData _metaData;
        private final Handler _handler;
        private final long _streamId;

        public MetaDataNotification(long streamId, MetaData metaData, Handler handler) {
            this._streamId = streamId;
            this._metaData = metaData;
            this._handler = handler;
        }

        public void notifyHandler() {
            this._handler.onMetaData(this._streamId, this._metaData);
        }
    }
}

