/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal.parser;

import java.nio.ByteBuffer;
import java.util.function.BooleanSupplier;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.internal.parser.BodyParser;
import org.eclipse.jetty.http3.internal.parser.HeaderParser;
import org.eclipse.jetty.http3.internal.parser.ParserListener;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBodyParser
extends BodyParser {
    private static final Logger LOG = LoggerFactory.getLogger(DataBodyParser.class);
    private final long streamId;
    private final BooleanSupplier isLast;
    private State state = State.INIT;
    private long length;

    public DataBodyParser(HeaderParser headerParser, ParserListener listener, long streamId, BooleanSupplier isLast) {
        super(headerParser, listener);
        this.streamId = streamId;
        this.isLast = isLast;
    }

    private void reset() {
        this.state = State.INIT;
        this.length = 0L;
    }

    @Override
    protected void emptyBody(ByteBuffer buffer) {
        this.onData(BufferUtil.EMPTY_BUFFER, this.isLast.getAsBoolean(), false);
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.length = this.getBodyLength();
                    this.state = State.DATA;
                    continue block4;
                }
                case 1: {
                    int size = (int)Math.min((long)buffer.remaining(), this.length);
                    int position = buffer.position();
                    int limit = buffer.limit();
                    buffer.limit(position + size);
                    ByteBuffer slice = buffer.slice();
                    buffer.limit(limit);
                    buffer.position(position + size);
                    boolean last = this.isLast.getAsBoolean() && !buffer.hasRemaining();
                    this.length -= (long)size;
                    if (this.length == 0L) {
                        this.reset();
                        this.onData(slice, last, false);
                        return BodyParser.Result.WHOLE_FRAME;
                    }
                    this.onData(slice, last, true);
                    return BodyParser.Result.FRAGMENT_FRAME;
                }
            }
            throw new IllegalStateException();
        }
        return BodyParser.Result.NO_FRAME;
    }

    private void onData(ByteBuffer buffer, boolean last, boolean fragment) {
        DataFrame frame = new DataFrame(buffer, last);
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifying fragment={} {}#{} left={}", new Object[]{fragment, frame, this.streamId, this.length});
        }
        this.notifyData(frame);
    }

    private void notifyData(DataFrame frame) {
        ParserListener listener = this.getParserListener();
        try {
            listener.onData(this.streamId, frame);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private static enum State {
        INIT,
        DATA;

    }
}

