/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;

public class DataFrame
extends Frame {
    private final ByteBuffer data;
    private final boolean last;
    private final int length;

    public DataFrame(ByteBuffer data, boolean last) {
        super(FrameType.DATA);
        this.data = data;
        this.last = last;
        this.length = data.remaining();
    }

    public ByteBuffer getByteBuffer() {
        return this.data;
    }

    public boolean isLast() {
        return this.last;
    }

    @Override
    public String toString() {
        return String.format("%s[last=%b,length=%d]", super.toString(), this.isLast(), this.length);
    }
}

