/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.frames;

import java.util.HashMap;
import java.util.Map;

public enum FrameType {
    DATA(0),
    HEADERS(1),
    PRIORITY(2),
    RST_STREAM(3),
    SETTINGS(4),
    PUSH_PROMISE(5),
    PING(6),
    GO_AWAY(7),
    WINDOW_UPDATE(8),
    CONTINUATION(9),
    PREFACE(-1),
    DISCONNECT(-2),
    FAILURE(-3);

    private final int type;

    public static FrameType from(int type) {
        return Types.types.get(type);
    }

    private FrameType(int type) {
        this.type = type;
        Types.types.put(type, this);
    }

    public int getType() {
        return this.type;
    }

    public boolean isSynthetic() {
        return this.getType() < 0;
    }

    private static class Types {
        private static final Map<Integer, FrameType> types = new HashMap<Integer, FrameType>();

        private Types() {
        }
    }
}

