/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.parser.SettingsBodyParser;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.TypeUtil;

public class HTTP2ServerConnection
extends HTTP2Connection
implements Connection.UpgradeTo {
    private final Queue<HttpChannelOverHTTP2> channels = new ConcurrentArrayQueue();
    private final ServerSessionListener listener;
    private final HttpConfiguration httpConfig;
    private final List<Frame> upgradeFrames = new ArrayList<Frame>();

    public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, HttpConfiguration httpConfig, ServerParser parser, ISession session, int inputBufferSize, ServerSessionListener listener) {
        super(byteBufferPool, executor, endPoint, (Parser)parser, session, inputBufferSize);
        this.listener = listener;
        this.httpConfig = httpConfig;
    }

    protected ServerParser getParser() {
        return (ServerParser)super.getParser();
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onUpgradeTo {} {}", new Object[]{this, BufferUtil.toDetailString((ByteBuffer)buffer)});
        }
        this.setInputBuffer(buffer);
    }

    public void onOpen() {
        this.notifyAccept(this.getSession());
        for (Frame frame : this.upgradeFrames) {
            this.getSession().onFrame(frame);
        }
        super.onOpen();
    }

    private void notifyAccept(ISession session) {
        try {
            this.listener.onAccept((Session)session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    public void onNewStream(Connector connector, IStream stream, HeadersFrame frame) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", new Object[]{frame, stream});
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onRequest(frame)) != null) {
            this.offerTask(task, false);
        }
    }

    public void onData(IStream stream, DataFrame frame, Callback callback) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", new Object[]{frame, stream});
        }
        if ((task = (channel = (HttpChannelOverHTTP2)((Object)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE))).requestContent(frame, callback)) != null) {
            this.offerTask(task, false);
        }
    }

    public void push(Connector connector, IStream stream, MetaData.Request request) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing push {} on {}", new Object[]{request, stream});
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onPushRequest(request)) != null) {
            this.offerTask(task, true);
        }
    }

    private HttpChannelOverHTTP2 provideHttpChannel(Connector connector, IStream stream) {
        HttpChannelOverHTTP2 channel = this.channels.poll();
        if (channel != null) {
            channel.getHttpTransport().setStream(stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recycling channel {} for {}", new Object[]{channel, this});
            }
        } else {
            HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(connector, this);
            transport.setStream(stream);
            channel = new ServerHttpChannelOverHTTP2(connector, this.httpConfig, this.getEndPoint(), transport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating channel {} for {}", new Object[]{channel, this});
            }
        }
        stream.setAttribute(IStream.CHANNEL_ATTRIBUTE, (Object)channel);
        return channel;
    }

    public boolean upgrade(MetaData.Request request) {
        if (HttpMethod.PRI.is(request.getMethod())) {
            this.getParser().directUpgrade();
        } else {
            SettingsFrame settingsFrame;
            HttpField settingsField = request.getFields().getField(HttpHeader.HTTP2_SETTINGS);
            if (settingsField == null) {
                throw new BadMessageException("Missing " + HttpHeader.HTTP2_SETTINGS + " header");
            }
            String value = settingsField.getValue();
            byte[] settings = B64Code.decodeRFC4648URL((String)(value == null ? "" : value));
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} settings {}", new Object[]{this, TypeUtil.toHexString((byte[])settings)});
            }
            if ((settingsFrame = SettingsBodyParser.parseBody((ByteBuffer)BufferUtil.toBuffer((byte[])settings))) == null) {
                LOG.warn("Invalid {} header value: {}", new Object[]{HttpHeader.HTTP2_SETTINGS, value});
                throw new BadMessageException();
            }
            this.getParser().standardUpgrade();
            this.upgradeFrames.add((Frame)new PrefaceFrame());
            this.upgradeFrames.add((Frame)settingsFrame);
            this.upgradeFrames.add((Frame)new HeadersFrame(1, (MetaData)new MetaData.Request(request), null, true));
        }
        return true;
    }

    private class ServerHttpChannelOverHTTP2
    extends HttpChannelOverHTTP2
    implements Closeable {
        public ServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
            super(connector, configuration, endPoint, transport);
        }

        @Override
        public void recycle() {
            super.recycle();
            HTTP2ServerConnection.this.channels.offer(this);
        }

        public void onCompleted() {
            super.onCompleted();
            this.recycle();
        }

        @Override
        public void close() {
            IStream stream = this.getStream();
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.ENHANCE_YOUR_CALM_ERROR.code), Callback.NOOP);
            this.getHttpTransport().consumeInput();
            this.recycle();
        }
    }
}

