/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpTransportOverHTTP2
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverHTTP2.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final Callback commitCallback = new CommitCallback();
    private final Connector connector;
    private final HTTP2ServerConnection connection;
    private IStream stream;

    public HttpTransportOverHTTP2(Connector connector, HTTP2ServerConnection connection) {
        this.connector = connector;
        this.connection = connection;
    }

    public boolean isOptimizedForDirectBuffers() {
        return this.connection.getEndPoint().isOptimizedForDirectBuffers();
    }

    public IStream getStream() {
        return this.stream;
    }

    public void setStream(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} setStream {}", new Object[]{this, stream.getId()});
        }
        this.stream = stream;
    }

    public void recycle() {
        this.stream = null;
        this.commit.set(false);
    }

    public void send(MetaData.Response info, boolean isHeadRequest, ByteBuffer content, boolean lastContent, Callback callback) {
        boolean hasContent;
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (info != null) {
            if (this.commit.compareAndSet(false, true)) {
                if (hasContent) {
                    this.commit(info, false, this.commitCallback);
                    this.send(content, lastContent, callback);
                } else {
                    this.commit(info, lastContent, callback);
                }
            } else {
                callback.failed((Throwable)new IllegalStateException("committed"));
            }
        } else if (hasContent || lastContent) {
            this.send(content, lastContent, callback);
        } else {
            callback.succeeded();
        }
    }

    public boolean isPushSupported() {
        return this.stream.getSession().isPushEnabled();
    }

    public void push(final MetaData.Request request) {
        if (!this.stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 Push disabled for {}", new Object[]{request});
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 Push {}", new Object[]{request});
        }
        this.stream.push(new PushPromiseFrame(this.stream.getId(), 0, (MetaData)request), (Promise)new Promise<Stream>(){

            public void succeeded(Stream pushStream) {
                HttpTransportOverHTTP2.this.connection.push(HttpTransportOverHTTP2.this.connector, (IStream)pushStream, request);
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not push " + request, x);
                }
            }
        }, (Stream.Listener)new Stream.Listener.Adapter());
    }

    private void commit(MetaData.Response info, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}:{}{} {}{}{}", new Object[]{this.stream.getId(), System.lineSeparator(), HttpVersion.HTTP_2, info.getStatus(), System.lineSeparator(), info.getFields()});
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, endStream);
        this.stream.headers(frame, callback);
    }

    private void send(ByteBuffer content, boolean lastContent, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}: {} content bytes{}", new Object[]{this.stream.getId(), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this.stream.getId(), content, lastContent);
        this.stream.data(frame, callback);
    }

    public void onCompleted() {
        if (!this.stream.isClosed()) {
            this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), (Callback)Callback.Adapter.INSTANCE);
            HttpChannel channel = (HttpChannel)this.stream.getAttribute(IStream.CHANNEL_ATTRIBUTE);
            channel.getRequest().getHttpInput().consumeAll();
        }
    }

    public void abort(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{} aborted", (long)this.stream.getId());
        }
        this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.INTERNAL_ERROR.code), (Callback)Callback.Adapter.INSTANCE);
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{} committed", (long)HttpTransportOverHTTP2.this.stream.getId());
            }
        }

        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #" + HttpTransportOverHTTP2.this.stream.getId() + " failed to commit", x);
            }
        }
    }
}

