/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.Parser;

public class PriorityBodyParser
extends BodyParser {
    private State state = State.PREPARE;
    private int cursor;
    private boolean exclusive;
    private int streamId;

    public PriorityBodyParser(HeaderParser headerParser, Parser.Listener listener) {
        super(headerParser, listener);
    }

    private void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.exclusive = false;
        this.streamId = 0;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block7: while (buffer.hasRemaining()) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() == 0) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_priority_frame");
                    }
                    int length = this.getBodyLength();
                    if (length != 5) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_priority_frame");
                    }
                    this.state = State.EXCLUSIVE;
                    continue block7;
                }
                case EXCLUSIVE: {
                    int currByte = buffer.get(buffer.position());
                    this.exclusive = (currByte & 0x80) == 128;
                    this.state = State.STREAM_ID;
                    continue block7;
                }
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt();
                        this.streamId &= Integer.MAX_VALUE;
                        this.state = State.WEIGHT;
                        continue block7;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block7;
                }
                case STREAM_ID_BYTES: {
                    int currByte = buffer.get() & 0xFF;
                    --this.cursor;
                    this.streamId += currByte << 8 * this.cursor;
                    if (this.cursor != 0) continue block7;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.WEIGHT;
                    continue block7;
                }
                case WEIGHT: {
                    int weight = buffer.get() & 0xFF;
                    return this.onPriority(this.streamId, weight, this.exclusive);
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private boolean onPriority(int streamId, int weight, boolean exclusive) {
        PriorityFrame frame = new PriorityFrame(streamId, this.getStreamId(), weight, exclusive);
        this.reset();
        this.notifyPriority(frame);
        return true;
    }

    private static enum State {
        PREPARE,
        EXCLUSIVE,
        STREAM_ID,
        STREAM_ID_BYTES,
        WEIGHT;

    }
}

