/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2Client
extends ContainerLifeCycle {
    private final Queue<ISession> sessions = new ConcurrentLinkedQueue<ISession>();
    private final SelectorManager selector;
    private final ByteBufferPool byteBufferPool;
    private long idleTimeout;

    public HTTP2Client() {
        this((Executor)new QueuedThreadPool());
    }

    public HTTP2Client(Executor executor) {
        this.addBean(executor);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        this.addBean(scheduler, true);
        this.selector = new ClientSelectorManager(executor, (Scheduler)scheduler);
        this.addBean(this.selector, true);
        this.byteBufferPool = new MappedByteBufferPool();
        this.addBean(this.byteBufferPool, true);
    }

    protected void doStop() throws Exception {
        this.closeConnections();
        super.doStop();
    }

    public void connect(InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(null, address, listener, promise);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        try {
            SocketChannel channel = SocketChannel.open();
            channel.socket().setTcpNoDelay(true);
            channel.configureBlocking(false);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("http2.client", (Object)this);
            context.put("http2.client.sessionListener", listener);
            context.put("http2.client.sessionPromise", promise);
            if (sslContextFactory != null) {
                context.put("ssl.context.factory", sslContextFactory);
            }
            context.put("ssl.peer.host", address.getHostString());
            context.put("ssl.peer.port", address.getPort());
            if (channel.connect(address)) {
                this.selector.accept(channel, context);
            } else {
                this.selector.connect(channel, context);
            }
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    private void closeConnections() {
        for (ISession session : this.sessions) {
            session.close(0, null, (Callback)Callback.Adapter.INSTANCE);
        }
        this.sessions.clear();
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean addSession(ISession session) {
        return this.sessions.offer(session);
    }

    public boolean removeSession(ISession session) {
        return this.sessions.remove(session);
    }

    private class ClientSelectorManager
    extends SelectorManager {
        private ClientSelectorManager(Executor executor, Scheduler scheduler) {
            super(executor, scheduler);
        }

        protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey selectionKey) throws IOException {
            return new SelectChannelEndPoint(channel, selector, selectionKey, this.getScheduler(), HTTP2Client.this.getIdleTimeout());
        }

        public Connection newConnection(SocketChannel channel, EndPoint endpoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            context.put("http2.client.byteBufferPool", HTTP2Client.this.byteBufferPool);
            context.put("http2.client.executor", this.getExecutor());
            context.put("http2.client.scheduler", this.getScheduler());
            HTTP2ClientConnectionFactory factory = new HTTP2ClientConnectionFactory();
            SslContextFactory sslContextFactory = (SslContextFactory)context.get("ssl.context.factory");
            if (sslContextFactory != null) {
                ALPNClientConnectionFactory alpn = new ALPNClientConnectionFactory(this.getExecutor(), (ClientConnectionFactory)factory, "h2-14");
                factory = new SslClientConnectionFactory(sslContextFactory, HTTP2Client.this.byteBufferPool, this.getExecutor(), (ClientConnectionFactory)alpn);
            }
            return factory.newConnection(endpoint, context);
        }
    }
}

