/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2ClientSession
extends HTTP2Session {
    private static final Logger LOG = Log.getLogger(HTTP2ClientSession.class);
    private final AtomicLong streamsOpened = new AtomicLong();
    private final AtomicLong streamsClosed = new AtomicLong();

    public HTTP2ClientSession(Scheduler scheduler, EndPoint endPoint, Generator generator, Session.Listener listener, FlowControlStrategy flowControl) {
        super(scheduler, endPoint, generator, listener, flowControl, 1);
    }

    protected void onStreamOpened(IStream stream) {
        super.onStreamOpened(stream);
        this.streamsOpened.incrementAndGet();
    }

    protected void onStreamClosed(IStream stream) {
        super.onStreamClosed(stream);
        this.streamsClosed.incrementAndGet();
    }

    public long getStreamsOpened() {
        return this.streamsOpened.get();
    }

    public long getStreamsClosed() {
        return this.streamsClosed.get();
    }

    public void onHeaders(HeadersFrame frame) {
        int streamId;
        IStream stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", new Object[]{frame});
        }
        if ((stream = this.getStream(streamId = frame.getStreamId())) != null) {
            MetaData metaData = frame.getMetaData();
            if (metaData.isRequest()) {
                this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "invalid_response");
            } else {
                stream.process((Frame)frame, Callback.NOOP);
                this.notifyHeaders(stream, frame);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream #{} not found", (long)streamId);
            }
            if (HTTP2ClientSession.isClientStream((int)streamId)) {
                if (!this.isLocalStreamClosed(streamId)) {
                    this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unexpected_headers_frame");
                }
            } else if (!this.isRemoteStreamClosed(streamId)) {
                this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unexpected_headers_frame");
            }
        }
    }

    protected void onResetForUnknownStream(ResetFrame frame) {
        boolean closed;
        int streamId = frame.getStreamId();
        boolean bl = closed = HTTP2ClientSession.isClientStream((int)streamId) ? this.isLocalStreamClosed(streamId) : this.isRemoteStreamClosed(streamId);
        if (closed) {
            this.notifyReset((Session)this, frame);
        } else {
            this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unexpected_rst_stream_frame");
        }
    }

    public void onPushPromise(PushPromiseFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", new Object[]{frame});
        }
        int streamId = frame.getStreamId();
        int pushStreamId = frame.getPromisedStreamId();
        IStream stream = this.getStream(streamId);
        if (stream == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring {}, stream #{} not found", new Object[]{frame, streamId});
            }
        } else {
            IStream pushStream = this.createRemoteStream(pushStreamId, frame.getMetaData());
            if (pushStream != null) {
                pushStream.process((Frame)frame, Callback.NOOP);
                Stream.Listener listener = this.notifyPush(stream, pushStream, frame);
                pushStream.setListener(listener);
            }
        }
    }

    private Stream.Listener notifyPush(IStream stream, IStream pushStream, PushPromiseFrame frame) {
        Stream.Listener listener = stream.getListener();
        if (listener == null) {
            return null;
        }
        try {
            return listener.onPush((Stream)pushStream, frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
            return null;
        }
    }
}

