/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.gcloud.session;

import com.google.gcloud.datastore.Blob;
import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreFactory;
import com.google.gcloud.datastore.Entity;
import com.google.gcloud.datastore.GqlQuery;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.KeyFactory;
import com.google.gcloud.datastore.Query;
import com.google.gcloud.datastore.QueryResults;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.gcloud.session.GCloudConfiguration;
import org.eclipse.jetty.gcloud.session.GCloudSessionIdManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.MemSession;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class GCloudSessionManager
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final String KIND = "GCloudSession";
    public static final int DEFAULT_MAX_QUERY_RESULTS = 100;
    public static final long DEFAULT_SCAVENGE_SEC = 600L;
    private ConcurrentHashMap<String, Session> _sessions;
    private long _staleIntervalSec = 0L;
    protected Scheduler.Task _task;
    protected Scheduler _scheduler;
    protected Scavenger _scavenger;
    protected long _scavengeIntervalMs = 600000L;
    protected boolean _ownScheduler;
    private Datastore _datastore;
    private KeyFactory _keyFactory;
    private SessionEntityConverter _converter;
    private int _maxResults = 100;

    public void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        GCloudConfiguration config = ((GCloudSessionIdManager)this._sessionIdManager).getConfig();
        if (config == null) {
            throw new IllegalStateException("No gcloud configuration");
        }
        this._datastore = DatastoreFactory.instance().get(config.getDatastoreOptions());
        this._keyFactory = (KeyFactory)this._datastore.newKeyFactory().kind(KIND);
        this._converter = new SessionEntityConverter();
        this._sessions = new ConcurrentHashMap();
        this._scheduler = (Scheduler)this.getSessionHandler().getServer().getBean(Scheduler.class);
        if (this._scheduler == null) {
            this._scheduler = new ScheduledExecutorScheduler();
            this._ownScheduler = true;
            this._scheduler.start();
        } else if (!this._scheduler.isStarted()) {
            throw new IllegalStateException("Shared scheduler not started");
        }
        this.setScavengeIntervalSec(this.getScavengeIntervalSec());
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this._task != null) {
            this._task.cancel();
        }
        this._task = null;
        if (this._ownScheduler && this._scheduler != null) {
            this._scheduler.stop();
        }
        this._scheduler = null;
        this._sessions.clear();
        this._sessions = null;
    }

    public void scavenge() {
        try {
            this.scavengeGCloudDataStore();
        }
        catch (Exception e) {
            LOG.warn("Problem scavenging", (Throwable)e);
        }
    }

    protected void scavengeGCloudDataStore() throws Exception {
        long now = System.currentTimeMillis();
        now -= this._scavengeIntervalMs / 2L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging for sessions expired before " + now, new Object[0]);
        }
        GqlQuery.Builder builder = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.ENTITY, (String)("select * from GCloudSession where expiry < @1 limit " + this._maxResults));
        builder.allowLiteral(true);
        builder.addBinding(new long[]{now});
        GqlQuery query = builder.build();
        QueryResults results = this._datastore.run((Query)query);
        while (results.hasNext()) {
            Entity sessionEntity = (Entity)results.next();
            this.scavengeSession(sessionEntity);
        }
    }

    protected void scavengeSession(Entity e) throws Exception {
        Session memSession;
        long now = System.currentTimeMillis();
        Session session = this._converter.sessionFromEntity(e);
        if (session == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging session: {}", new Object[]{session.getId()});
        }
        if ((memSession = this._sessions.putIfAbsent(session.getId(), session)) == null) {
            memSession = session;
        }
        if (memSession.isExpiredAt(now)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} is definitely expired", new Object[]{memSession.getId()});
            }
            memSession.timeout();
        }
    }

    public long getScavengeIntervalSec() {
        return this._scavengeIntervalMs / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengeIntervalSec(long sec) {
        long period;
        long old_period = this._scavengeIntervalMs;
        this._scavengeIntervalMs = period = sec * 1000L;
        if (this._scavengeIntervalMs > 0L) {
            long tenPercent = this._scavengeIntervalMs / 10L;
            if (System.currentTimeMillis() % 2L == 0L) {
                this._scavengeIntervalMs += tenPercent;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scavenging every " + this._scavengeIntervalMs + " ms", new Object[0]);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging disabled", new Object[0]);
        }
        GCloudSessionManager gCloudSessionManager = this;
        synchronized (gCloudSessionManager) {
            if (this._scheduler != null && (period != old_period || this._task == null)) {
                if (this._task != null) {
                    this._task.cancel();
                }
                if (this._scavengeIntervalMs > 0L) {
                    if (this._scavenger == null) {
                        this._scavenger = new Scavenger();
                    }
                    this._task = this._scheduler.schedule((Runnable)this._scavenger, this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public long getStaleIntervalSec() {
        return this._staleIntervalSec;
    }

    public void setStaleIntervalSec(long staleIntervalSec) {
        this._staleIntervalSec = staleIntervalSec;
    }

    public int getMaxResults() {
        return this._maxResults;
    }

    public void setMaxResults(int maxResults) {
        this._maxResults = this._maxResults <= 0 ? 100 : maxResults;
    }

    protected void addSession(AbstractSession session) {
        if (session == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding session({}) to session manager for context {} on worker {}", new Object[]{session.getClusterId(), GCloudSessionManager.getContextPath(this.getContext()), this.getSessionIdManager().getWorkerName() + " with lastnode=" + ((Session)session).getLastNode()});
        }
        this._sessions.put(session.getClusterId(), (Session)session);
        try {
            session.willPassivate();
            this.save((Session)session);
            session.didActivate();
        }
        catch (Exception e) {
            LOG.warn("Unable to store new session id=" + session.getId(), (Throwable)e);
        }
    }

    public AbstractSession getSession(String idInCluster) {
        Session session = null;
        Session memSession = this._sessions.get(idInCluster);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSession({}) {} in session map", new Object[]{idInCluster, memSession == null ? "not" : ""});
        }
        long now = System.currentTimeMillis();
        try {
            if (memSession == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getSession({}): loading session data from cluster", new Object[]{idInCluster});
                }
                if ((session = this.load(this.makeKey(idInCluster, this._context))) != null) {
                    if (session.getExpiry() > 0L && session.getExpiry() <= now) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession ({}): Session expired", new Object[]{idInCluster});
                        }
                        ((GCloudSessionIdManager)this.getSessionIdManager()).removeSession((HttpSession)session);
                        return null;
                    }
                    session.setLastNode(this.getSessionIdManager().getWorkerName());
                    Session existingSession = this._sessions.putIfAbsent(idInCluster, session);
                    if (existingSession != null) {
                        session = existingSession;
                        LOG.debug("getSession({}): using session loaded by another request thread ", new Object[]{idInCluster});
                    } else {
                        session.didActivate();
                        LOG.debug("getSession({}): loaded session from cluster", new Object[]{idInCluster});
                    }
                    return session;
                }
                LOG.debug("getSession({}): No session in cluster matching", new Object[]{idInCluster});
                return null;
            }
            LOG.debug("getSession({}): returning session from local memory ", new Object[]{memSession.getClusterId()});
            return memSession;
        }
        catch (Exception e) {
            LOG.warn("Unable to load session=" + idInCluster, (Throwable)e);
            return null;
        }
    }

    protected void shutdownSessions() throws Exception {
        HashSet keys = new HashSet(this._sessions.keySet());
        for (String key : keys) {
            Session session = this._sessions.remove(key);
            try {
                if (!session.isDirty()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Saving dirty session {} before exiting ", new Object[]{session.getId()});
                }
                this.save(session);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    protected boolean removeSession(String idInCluster) {
        Session session = this._sessions.remove(idInCluster);
        try {
            if (session != null) {
                this.delete(session);
            }
        }
        catch (Exception e) {
            LOG.warn("Problem deleting session id=" + idInCluster, (Throwable)e);
        }
        return session != null;
    }

    public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        Session session = null;
        try {
            session = this._sessions.remove(oldClusterId);
            if (session != null) {
                this.delete(session);
                session.swapId(newClusterId, newNodeId);
                this._sessions.put(newClusterId, session);
                this.save(session);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        super.renewSessionId(oldClusterId, oldNodeId, newClusterId, newNodeId);
    }

    protected Session load(Key key) throws Exception {
        Entity entity;
        if (this._datastore == null) {
            throw new IllegalStateException("No DataStore");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading session {} from DataStore", new Object[]{key});
        }
        if ((entity = this._datastore.get(key)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No session {} in DataStore ", new Object[]{key});
            }
            return null;
        }
        Session session = this._converter.sessionFromEntity(entity);
        session.setLastSyncTime(System.currentTimeMillis());
        return session;
    }

    protected void save(Session session) throws Exception {
        if (this._datastore == null) {
            throw new IllegalStateException("No DataStore");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing session {} to DataStore", new Object[]{session.getId()});
        }
        Entity entity = this._converter.entityFromSession(session, this.makeKey(session, this._context));
        this._datastore.put(new Entity[]{entity});
        session.setLastSyncTime(System.currentTimeMillis());
    }

    protected void delete(Session session) {
        if (this._datastore == null) {
            throw new IllegalStateException("No DataStore");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing session {} from DataStore", new Object[]{session.getId()});
        }
        this._datastore.delete(new Key[]{this.makeKey(session, this._context)});
    }

    public void invalidateSession(String idInCluster) {
        Session session = this._sessions.get(idInCluster);
        if (session != null) {
            session.invalidate();
        }
    }

    private Key makeKey(Session session, ContextHandler.Context context) {
        return this.makeKey(session.getId(), context);
    }

    private Key makeKey(String id, ContextHandler.Context context) {
        String key = GCloudSessionManager.getContextPath(context);
        key = key + "_" + GCloudSessionManager.getVirtualHost(context);
        key = key + "_" + id;
        return this._keyFactory.newKey(key);
    }

    private static String getContextPath(ContextHandler.Context context) {
        return GCloudSessionManager.canonicalize(context.getContextPath());
    }

    private static String getVirtualHost(ContextHandler.Context context) {
        String vhost = "0.0.0.0";
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    private static String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return path.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    public class Session
    extends MemSession {
        private ReentrantLock _lock;
        private String _contextPath;
        private long _expiryTime;
        private long _lastSyncTime;
        private String _lastNode;
        protected boolean _dirty;
        private String _vhost;
        private AtomicInteger _activeThreads;

        protected Session(HttpServletRequest request) {
            super((AbstractSessionManager)GCloudSessionManager.this, request);
            this._lock = new ReentrantLock();
            this._dirty = false;
            this._activeThreads = new AtomicInteger(0);
            long maxInterval = this.getMaxInactiveInterval();
            this._expiryTime = maxInterval <= 0L ? 0L : System.currentTimeMillis() + maxInterval * 1000L;
            this._lastNode = GCloudSessionManager.this.getSessionIdManager().getWorkerName();
            this.setVHost(GCloudSessionManager.getVirtualHost(GCloudSessionManager.this._context));
            this.setContextPath(GCloudSessionManager.getContextPath(GCloudSessionManager.this._context));
            this._activeThreads.incrementAndGet();
        }

        protected Session(String sessionId, long created, long accessed, long maxInterval) {
            super((AbstractSessionManager)GCloudSessionManager.this, created, accessed, sessionId);
            this._lock = new ReentrantLock();
            this._dirty = false;
            this._activeThreads = new AtomicInteger(0);
            this._expiryTime = maxInterval <= 0L ? 0L : System.currentTimeMillis() + maxInterval * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean access(long time) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Access session({}) for context {} on worker {}", new Object[]{this.getId(), this.getContextPath(), GCloudSessionManager.this.getSessionIdManager().getWorkerName()});
            }
            try {
                long now = System.currentTimeMillis();
                this._lock.lock();
                if (this._activeThreads.incrementAndGet() == 1 && GCloudSessionManager.this.getStaleIntervalSec() > 0L && now - this.getLastSyncTime() >= GCloudSessionManager.this.getStaleIntervalSec() * 1000L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Acess session({}) for context {} on worker {} stale session. Reloading.", new Object[]{this.getId(), this.getContextPath(), GCloudSessionManager.this.getSessionIdManager().getWorkerName()});
                    }
                    this.refresh();
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            finally {
                this._lock.unlock();
            }
            if (super.access(time)) {
                int maxInterval = this.getMaxInactiveInterval();
                this._expiryTime = maxInterval <= 0 ? 0L : time + (long)maxInterval * 1000L;
                return true;
            }
            return false;
        }

        protected void complete() {
            block9: {
                super.complete();
                this._lock.lock();
                try {
                    if (this._activeThreads.decrementAndGet() != 0) break block9;
                    try {
                        if (this.isValid() && (this._dirty || this.getLastSyncTime() == 0L || this.isStale(System.currentTimeMillis()))) {
                            this.willPassivate();
                            GCloudSessionManager.this.save(this);
                            this.didActivate();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Problem saving session({})", new Object[]{this.getId(), e});
                    }
                    finally {
                        this._dirty = false;
                    }
                }
                finally {
                    this._lock.unlock();
                }
            }
        }

        protected boolean isStale(long atTime) {
            return GCloudSessionManager.this.getStaleIntervalSec() > 0L && atTime - this.getLastSyncTime() >= GCloudSessionManager.this.getStaleIntervalSec() * 1000L;
        }

        protected boolean isDirty() {
            return this._dirty;
        }

        protected void timeout() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timing out session {}", new Object[]{this.getId()});
            }
            super.timeout();
        }

        private void refresh() throws Exception {
            Session fresh = GCloudSessionManager.this.load(GCloudSessionManager.this.makeKey(this.getClusterId(), GCloudSessionManager.this._context));
            if (fresh == null) {
                this.invalidate();
                return;
            }
            if (fresh.getLastNode().equals(this.getLastNode())) {
                return;
            }
            this.setLastNode(GCloudSessionManager.this.getSessionIdManager().getWorkerName());
            this.willPassivate();
            if (fresh.getAttributes() == 0) {
                this.clearAttributes();
            } else {
                for (String key : fresh.getAttributeMap().keySet()) {
                    Object freshvalue = fresh.getAttribute(key);
                    if (this.getAttribute(key) == null) {
                        this.doPutOrRemove(key, freshvalue);
                        this.bindValue(key, freshvalue);
                        continue;
                    }
                    this.doPutOrRemove(key, freshvalue);
                }
                for (String key : this.getNames()) {
                    if (fresh.getAttribute(key) != null) continue;
                    Object oldvalue = this.getAttribute(key);
                    this.doPutOrRemove(key, null);
                    this.unbindValue(key, oldvalue);
                }
            }
            this.didActivate();
        }

        public void setExpiry(long expiry) {
            this._expiryTime = expiry;
        }

        public long getExpiry() {
            return this._expiryTime;
        }

        public boolean isExpiredAt(long time) {
            if (this._expiryTime <= 0L) {
                return false;
            }
            return this._expiryTime <= time;
        }

        public void swapId(String newId, String newNodeId) {
            this._lock.lock();
            this.setClusterId(newId);
            this.setNodeId(newNodeId);
            this._lock.unlock();
        }

        public void setAttribute(String name, Object value) {
            Object old = this.changeAttribute(name, value);
            if (value == null && old == null) {
                return;
            }
            this._dirty = true;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public void setContextPath(String contextPath) {
            this._contextPath = contextPath;
        }

        public String getVHost() {
            return this._vhost;
        }

        public void setVHost(String vhost) {
            this._vhost = vhost;
        }

        public String getLastNode() {
            return this._lastNode;
        }

        public void setLastNode(String lastNode) {
            this._lastNode = lastNode;
        }

        public long getLastSyncTime() {
            return this._lastSyncTime;
        }

        public void setLastSyncTime(long lastSyncTime) {
            this._lastSyncTime = lastSyncTime;
        }
    }

    public class SerializableSessionData
    implements Serializable {
        private static final long serialVersionUID = -7779120106058533486L;
        String clusterId;
        String contextPath;
        String vhost;
        long accessed;
        long lastAccessed;
        long createTime;
        long cookieSetTime;
        String lastNode;
        long expiry;
        long maxInactive;
        Map<String, Object> attributes;

        public SerializableSessionData() {
        }

        public SerializableSessionData(Session s) {
            this.clusterId = s.getClusterId();
            this.contextPath = s.getContextPath();
            this.vhost = s.getVHost();
            this.accessed = s.getAccessed();
            this.lastAccessed = s.getLastAccessedTime();
            this.createTime = s.getCreationTime();
            this.cookieSetTime = s.getCookieSetTime();
            this.lastNode = s.getLastNode();
            this.expiry = s.getExpiry();
            this.maxInactive = s.getMaxInactiveInterval();
            this.attributes = s.getAttributeMap();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeUTF(this.clusterId);
            out.writeUTF(this.contextPath);
            out.writeUTF(this.vhost);
            out.writeLong(this.accessed);
            out.writeLong(this.lastAccessed);
            out.writeLong(this.createTime);
            out.writeLong(this.cookieSetTime);
            out.writeUTF(this.lastNode);
            out.writeLong(this.expiry);
            out.writeLong(this.maxInactive);
            out.writeObject(this.attributes);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.clusterId = in.readUTF();
            this.contextPath = in.readUTF();
            this.vhost = in.readUTF();
            this.accessed = in.readLong();
            this.lastAccessed = in.readLong();
            this.createTime = in.readLong();
            this.cookieSetTime = in.readLong();
            this.lastNode = in.readUTF();
            this.expiry = in.readLong();
            this.maxInactive = in.readLong();
            this.attributes = (HashMap)in.readObject();
        }
    }

    public class SessionEntityConverter {
        public final String CLUSTERID = "clusterId";
        public final String CONTEXTPATH = "contextPath";
        public final String VHOST = "vhost";
        public final String ACCESSED = "accessed";
        public final String LASTACCESSED = "lastAccessed";
        public final String CREATETIME = "createTime";
        public final String COOKIESETTIME = "cookieSetTime";
        public final String LASTNODE = "lastNode";
        public final String EXPIRY = "expiry";
        public final String MAXINACTIVE = "maxInactive";
        public final String ATTRIBUTES = "attributes";

        public Entity entityFromSession(Session session, Key key) throws Exception {
            if (session == null) {
                return null;
            }
            Entity entity = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(session.getAttributeMap());
            oos.flush();
            entity = ((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Key)key).set("clusterId", session.getId())).set("contextPath", session.getContextPath())).set("vhost", session.getVHost())).set("accessed", session.getAccessed())).set("lastAccessed", session.getLastAccessedTime())).set("createTime", session.getCreationTime())).set("cookieSetTime", session.getCookieSetTime())).set("lastNode", session.getLastNode())).set("expiry", session.getExpiry())).set("maxInactive", (long)session.getMaxInactiveInterval())).set("attributes", Blob.copyFrom((byte[])baos.toByteArray()))).build();
            return entity;
        }

        public Session sessionFromEntity(final Entity entity) throws Exception {
            if (entity == null) {
                return null;
            }
            final AtomicReference reference = new AtomicReference();
            final AtomicReference exception = new AtomicReference();
            Runnable load = new Runnable(){

                @Override
                public void run() {
                    try {
                        String clusterId = entity.getString("clusterId");
                        String contextPath = entity.getString("contextPath");
                        String vhost = entity.getString("vhost");
                        long accessed = entity.getLong("accessed");
                        long lastAccessed = entity.getLong("lastAccessed");
                        long createTime = entity.getLong("createTime");
                        long cookieSetTime = entity.getLong("cookieSetTime");
                        String lastNode = entity.getString("lastNode");
                        long expiry = entity.getLong("expiry");
                        long maxInactive = entity.getLong("maxInactive");
                        Blob blob = entity.getBlob("attributes");
                        Session session = new Session(clusterId, createTime, accessed, maxInactive);
                        session.setLastNode(lastNode);
                        session.setContextPath(contextPath);
                        session.setVHost(vhost);
                        session.setCookieSetTime(cookieSetTime);
                        session.setLastAccessedTime(lastAccessed);
                        session.setLastNode(lastNode);
                        session.setExpiry(expiry);
                        try (ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(blob.asInputStream());){
                            Object o = ois.readObject();
                            session.addAttributes((Map)o);
                        }
                        reference.set(session);
                    }
                    catch (Exception e) {
                        exception.set(e);
                    }
                }
            };
            if (GCloudSessionManager.this._context == null) {
                load.run();
            } else {
                GCloudSessionManager.this._context.getContextHandler().handle(null, load);
            }
            if (exception.get() != null) {
                ((Exception)exception.get()).printStackTrace();
                throw (Exception)exception.get();
            }
            return (Session)((Object)reference.get());
        }
    }

    protected class Scavenger
    implements Runnable {
        protected Scavenger() {
        }

        @Override
        public void run() {
            try {
                GCloudSessionManager.this.scavenge();
            }
            finally {
                if (GCloudSessionManager.this._scheduler != null && GCloudSessionManager.this._scheduler.isRunning()) {
                    GCloudSessionManager.this._task = GCloudSessionManager.this._scheduler.schedule((Runnable)this, GCloudSessionManager.this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

