/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.gcloud.session;

import com.google.gcloud.AuthCredentials;
import com.google.gcloud.datastore.DatastoreOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Properties;
import org.eclipse.jetty.util.security.Password;

public class GCloudConfiguration {
    public static final String PROJECT_ID = "projectId";
    public static final String P12 = "p12";
    public static final String PASSWORD = "password";
    public static final String SERVICE_ACCOUNT = "serviceAccount";
    private String _projectId;
    private File _p12File;
    private String _serviceAccount;
    private String _password;
    private AuthCredentials _authCredentials;
    private DatastoreOptions _options;

    public static GCloudConfiguration fromFile(String propsFile) throws IOException {
        if (propsFile == null) {
            throw new IllegalArgumentException("Null properties file");
        }
        File f = new File(propsFile);
        if (!f.exists()) {
            throw new IllegalArgumentException("No such file " + f.getAbsolutePath());
        }
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(f);){
            props.load(is);
        }
        GCloudConfiguration config = new GCloudConfiguration();
        config.setProjectId(props.getProperty(PROJECT_ID));
        config.setP12File(props.getProperty(P12));
        config.setPassword(props.getProperty(PASSWORD));
        config.setServiceAccount(props.getProperty(SERVICE_ACCOUNT));
        return config;
    }

    public String getProjectId() {
        return this._projectId;
    }

    public File getP12File() {
        return this._p12File;
    }

    public String getServiceAccount() {
        return this._serviceAccount;
    }

    public void setProjectId(String projectId) {
        this.checkForModification();
        this._projectId = projectId;
    }

    public void setP12File(String file) {
        this.checkForModification();
        this._p12File = new File(file);
    }

    public void setServiceAccount(String serviceAccount) {
        this.checkForModification();
        this._serviceAccount = serviceAccount;
    }

    public void setPassword(String pwd) {
        this.checkForModification();
        Password p = new Password(pwd);
        this._password = p.toString();
    }

    public DatastoreOptions getDatastoreOptions() throws Exception {
        if (this._options == null) {
            this._options = ((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.builder().projectId(this._projectId)).authCredentials(this.getAuthCredentials())).build();
        }
        return this._options;
    }

    public AuthCredentials getAuthCredentials() throws Exception {
        if (this._authCredentials == null) {
            if (this._password == null) {
                throw new IllegalStateException("No password");
            }
            if (this._projectId == null) {
                throw new IllegalStateException("No project id");
            }
            if (this._projectId == null) {
                throw new IllegalStateException("No project id");
            }
            if (this._p12File == null || !this._p12File.exists()) {
                throw new IllegalStateException("No p12 file: " + (this._p12File == null ? "null" : this._p12File.getAbsolutePath()));
            }
            if (this._serviceAccount == null) {
                throw new IllegalStateException("No service account");
            }
            char[] pwdChars = this._password.toCharArray();
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(new FileInputStream(this.getP12File()), pwdChars);
            PrivateKey privateKey = (PrivateKey)keystore.getKey("privatekey", pwdChars);
            this._authCredentials = AuthCredentials.createFor((String)this.getServiceAccount(), (PrivateKey)privateKey);
        }
        return this._authCredentials;
    }

    protected void checkForModification() throws IllegalStateException {
        if (this._authCredentials != null || this._options != null) {
            throw new IllegalStateException("Cannot modify auth configuration after datastore initialized");
        }
    }
}

