/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.fcgi.generator.ServerGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class HttpTransportOverFCGI
implements HttpTransport {
    private final ServerGenerator generator;
    private final Flusher flusher;
    private final int request;
    private volatile boolean head;
    private volatile boolean shutdown;
    private volatile boolean aborted;

    public HttpTransportOverFCGI(ByteBufferPool byteBufferPool, Flusher flusher, int request, boolean sendStatus200) {
        this.generator = new ServerGenerator(byteBufferPool, sendStatus200);
        this.flusher = flusher;
        this.request = request;
    }

    public boolean isOptimizedForDirectBuffers() {
        return false;
    }

    public void send(MetaData.Response info, boolean head, ByteBuffer content, boolean lastContent, Callback callback) {
        if (info != null) {
            this.commit(info, head, content, lastContent, callback);
        } else {
            if (head) {
                if (lastContent) {
                    Generator.Result result = this.generateResponseContent(BufferUtil.EMPTY_BUFFER, true, callback);
                    this.flusher.flush(new Generator.Result[]{result});
                } else {
                    callback.succeeded();
                }
            } else {
                Generator.Result result = this.generateResponseContent(content, lastContent, callback);
                this.flusher.flush(new Generator.Result[]{result});
            }
            if (lastContent && this.shutdown) {
                this.flusher.shutdown();
            }
        }
    }

    public boolean isPushSupported() {
        return false;
    }

    public void push(MetaData.Request request) {
    }

    private void commit(MetaData.Response info, boolean head, ByteBuffer content, boolean lastContent, Callback callback) {
        this.head = head;
        boolean shutdown = this.shutdown = info.getFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        if (head) {
            if (lastContent) {
                Generator.Result headersResult = this.generateResponseHeaders(info, (Callback)Callback.Adapter.INSTANCE);
                Generator.Result contentResult = this.generateResponseContent(BufferUtil.EMPTY_BUFFER, true, callback);
                this.flusher.flush(new Generator.Result[]{headersResult, contentResult});
            } else {
                Generator.Result headersResult = this.generateResponseHeaders(info, callback);
                this.flusher.flush(new Generator.Result[]{headersResult});
            }
        } else {
            Generator.Result headersResult = this.generateResponseHeaders(info, (Callback)Callback.Adapter.INSTANCE);
            Generator.Result contentResult = this.generateResponseContent(content, lastContent, callback);
            this.flusher.flush(new Generator.Result[]{headersResult, contentResult});
        }
        if (lastContent && shutdown) {
            this.flusher.shutdown();
        }
    }

    protected Generator.Result generateResponseHeaders(MetaData.Response info, Callback callback) {
        return this.generator.generateResponseHeaders(this.request, info.getStatus(), info.getReason(), info.getFields(), callback);
    }

    protected Generator.Result generateResponseContent(ByteBuffer buffer, boolean lastContent, Callback callback) {
        return this.generator.generateResponseContent(this.request, buffer, lastContent, this.aborted, callback);
    }

    public void abort(Throwable failure) {
        this.aborted = true;
    }

    public void onCompleted() {
    }
}

