/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.fcgi.client.http.HttpConnectionOverFCGI;
import org.eclipse.jetty.fcgi.client.http.HttpDestinationOverFCGI;
import org.eclipse.jetty.fcgi.client.http.MultiplexHttpDestinationOverFCGI;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The FastCGI/1.0 client transport")
public class HttpClientTransportOverFCGI
extends AbstractConnectorHttpClientTransport {
    private final boolean multiplexed;
    private final String scriptRoot;

    public HttpClientTransportOverFCGI(String scriptRoot) {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2), false, scriptRoot);
    }

    public HttpClientTransportOverFCGI(int selectors, boolean multiplexed, String scriptRoot) {
        super(selectors);
        this.multiplexed = multiplexed;
        this.scriptRoot = scriptRoot;
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            int maxConnections = httpClient.getMaxConnectionsPerDestination();
            return this.isMultiplexed() ? new MultiplexConnectionPool(destination, maxConnections, (Callback)destination, httpClient.getMaxRequestsQueuedPerDestination()) : new DuplexConnectionPool(destination, maxConnections, (Callback)destination);
        });
    }

    @ManagedAttribute(value="Whether connections are multiplexed", readonly=true)
    public boolean isMultiplexed() {
        return this.multiplexed;
    }

    @ManagedAttribute(value="The scripts root directory", readonly=true)
    public String getScriptRoot() {
        return this.scriptRoot;
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return this.isMultiplexed() ? new MultiplexHttpDestinationOverFCGI(this.getHttpClient(), origin) : new HttpDestinationOverFCGI(this.getHttpClient(), origin);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverFCGI connection = this.newHttpConnection(endPoint, destination, (Promise<org.eclipse.jetty.client.api.Connection>)promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", new Object[]{connection});
        }
        return this.customize((Connection)connection, context);
    }

    protected HttpConnectionOverFCGI newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<org.eclipse.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverFCGI(endPoint, destination, promise, this.isMultiplexed());
    }

    protected void customize(Request request, HttpFields fastCGIHeaders) {
        fastCGIHeaders.put("DOCUMENT_ROOT", this.getScriptRoot());
    }
}

