/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.ServerParser;

public class BeginRequestContentParser
extends ContentParser {
    private final ServerParser.Listener listener;
    private State state = State.ROLE;
    private int cursor;
    private int role;
    private int flags;

    public BeginRequestContentParser(HeaderParser headerParser, ServerParser.Listener listener) {
        super(headerParser);
        this.listener = listener;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block7: while (buffer.hasRemaining()) {
            switch (this.state) {
                case ROLE: {
                    if (buffer.remaining() >= 2) {
                        this.role = buffer.getShort();
                        this.state = State.FLAGS;
                        continue block7;
                    }
                    this.state = State.ROLE_BYTES;
                    this.cursor = 0;
                    continue block7;
                }
                case ROLE_BYTES: {
                    int halfShort = buffer.get() & 0xFF;
                    this.role = (this.role << 8) + halfShort;
                    if (++this.cursor != 2) continue block7;
                    this.state = State.FLAGS;
                    continue block7;
                }
                case FLAGS: {
                    this.flags = buffer.get() & 0xFF;
                    this.state = State.RESERVED;
                    continue block7;
                }
                case RESERVED: {
                    if (buffer.remaining() >= 5) {
                        buffer.position(buffer.position() + 5);
                        this.onStart();
                        this.reset();
                        return true;
                    }
                    this.state = State.RESERVED_BYTES;
                    this.cursor = 0;
                    continue block7;
                }
                case RESERVED_BYTES: {
                    buffer.get();
                    if (++this.cursor != 5) continue block7;
                    this.onStart();
                    this.reset();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onStart() {
        this.listener.onStart(this.getRequest(), FCGI.Role.from(this.role), this.flags);
    }

    private void reset() {
        this.state = State.ROLE;
        this.cursor = 0;
        this.role = 0;
        this.flags = 0;
    }

    private static enum State {
        ROLE,
        ROLE_BYTES,
        FLAGS,
        RESERVED,
        RESERVED_BYTES;

    }
}

