/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.Resource;

public class FastFileServer {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{new FastFileHandler(new File(System.getProperty("user.dir"))), new DefaultHandler()});
        server.setHandler((Handler)handlers);
        server.start();
        server.join();
    }

    static class FastFileHandler
    extends AbstractHandler {
        private final MimeTypes mimeTypes = new MimeTypes();
        private final File dir;

        private FastFileHandler(File dir) {
            this.dir = dir;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ByteBuffer buffer;
            int SMALL = response.getBufferSize();
            int MEDIUM = 8 * SMALL;
            File file = new File(this.dir, request.getPathInfo());
            if (!file.exists()) {
                return;
            }
            baseRequest.setHandled(true);
            if (file.isDirectory()) {
                if (!request.getPathInfo().endsWith("/")) {
                    response.sendRedirect(response.encodeRedirectURL(request.getRequestURI() + "/"));
                    return;
                }
                String listing = Resource.newResource((File)file).getListHTML(request.getRequestURI(), request.getPathInfo().lastIndexOf("/") > 0, request.getQueryString());
                response.setContentType("text/html; charset=utf-8");
                response.getWriter().println(listing);
                return;
            }
            response.setDateHeader("Last-Modified", file.lastModified());
            response.setContentLengthLong(file.length());
            response.setContentType(this.mimeTypes.getMimeByExtension(file.getName()));
            if (file.length() < (long)SMALL) {
                ((HttpOutput)response.getOutputStream()).sendContent((ReadableByteChannel)FileChannel.open(file.toPath(), StandardOpenOption.READ));
                return;
            }
            final AsyncContext async = request.startAsync();
            Callback completionCB = new Callback(){

                public void succeeded() {
                    async.complete();
                }

                public void failed(Throwable x) {
                    x.printStackTrace();
                    async.complete();
                }
            };
            if (file.length() < (long)MEDIUM) {
                ((HttpOutput)response.getOutputStream()).sendContent((ReadableByteChannel)FileChannel.open(file.toPath(), StandardOpenOption.READ), completionCB);
                return;
            }
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
            }
            buffer = buffer.asReadOnlyBuffer();
            ((HttpOutput)response.getOutputStream()).sendContent(buffer, completionCB);
        }
    }
}

