/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.util.concurrent.Executor;
import org.eclipse.jetty.embedded.HelloHandler;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.spdy.server.NPNServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.spdy.server.http.ReferrerPushStrategy;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;

public class ManyConnectors {
    public static void main(String[] args) throws Exception {
        String jetty_home = System.getProperty("jetty.home", "../jetty-server/src/main/config");
        System.setProperty("jetty.home", jetty_home);
        Server server = new Server();
        ServerConnector connector0 = new ServerConnector(server);
        connector0.setPort(8080);
        connector0.setIdleTimeout(30000L);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(jetty_home + "/etc/keystore");
        sslContextFactory.setKeyStorePassword("OBF:1vny1zlo1x8e1vnw1vn61x8g1zlu1vn4");
        sslContextFactory.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
        ServerConnector connector1 = new ServerConnector(server, sslContextFactory);
        connector1.setPort(8443);
        HttpConfiguration config = new HttpConfiguration();
        config.setSecureScheme("https");
        config.setSecurePort(8443);
        config.setOutputBufferSize(32768);
        config.setRequestHeaderSize(8192);
        config.setResponseHeaderSize(8192);
        config.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory http = new HttpConnectionFactory(config);
        http.setInputBufferSize(16384);
        ReferrerPushStrategy push = new ReferrerPushStrategy();
        HTTPSPDYServerConnectionFactory spdy2 = new HTTPSPDYServerConnectionFactory(2, config, (PushStrategy)push);
        spdy2.setInputBufferSize(8192);
        spdy2.setInitialWindowSize(32768);
        HTTPSPDYServerConnectionFactory spdy3 = new HTTPSPDYServerConnectionFactory(3, config, (PushStrategy)push);
        spdy2.setInputBufferSize(8192);
        NPNServerConnectionFactory npn = new NPNServerConnectionFactory(new String[]{spdy3.getProtocol(), spdy2.getProtocol(), http.getProtocol()});
        npn.setDefaultProtocol(http.getProtocol());
        npn.setInputBufferSize(1024);
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, npn.getProtocol());
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(256);
        TimerScheduler scheduler = new TimerScheduler();
        ArrayByteBufferPool bufferPool = new ArrayByteBufferPool(32, 4096, 32768);
        ServerConnector connector2 = new ServerConnector(server, (Executor)threadPool, (Scheduler)scheduler, (ByteBufferPool)bufferPool, 2, 2, new ConnectionFactory[]{ssl, npn, spdy3, spdy2, http});
        connector2.setDefaultProtocol("ssl-npn");
        connector2.setPort(8444);
        connector2.setIdleTimeout(30000L);
        connector2.setSoLingerTime(10000);
        server.setConnectors(new Connector[]{connector0, connector1, connector2});
        server.setHandler((Handler)new HelloHandler());
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

