/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jetty.embedded.HelloHandler;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class SecuredHelloHandler {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        HashLoginService loginService = new HashLoginService("MyRealm", "src/test/resources/realm.properties");
        server.addBean((Object)loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        server.setHandler((Handler)security);
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"user", "admin"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add("user");
        knownRoles.add("admin");
        security.setConstraintMappings(Collections.singletonList(mapping), knownRoles);
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        security.setLoginService((LoginService)loginService);
        security.setStrict(false);
        HelloHandler hh = new HelloHandler();
        security.setHandler((Handler)hh);
        server.start();
        server.join();
    }
}

