/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class FileServer {
    public static void main(String[] args) throws Exception {
        Server server = new Server(args.length == 0 ? 8080 : Integer.parseInt(args[0]));
        ResourceHandler resource_handler = new ResourceHandler(){

            protected void doDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
                String listing = resource.getListHTML(request.getRequestURI(), request.getPathInfo().lastIndexOf("/") > 0);
                response.setContentType("text/html; charset=UTF-8");
                response.getWriter().println(listing);
            }
        };
        resource_handler.setWelcomeFiles(new String[]{"index.html"});
        resource_handler.setResourceBase(args.length == 2 ? args[1] : ".");
        Log.info((String)("serving " + resource_handler.getBaseResource()));
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resource_handler, new DefaultHandler()});
        server.setHandler((Handler)handlers);
        server.start();
        server.join();
    }
}

