/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jetty.ee9.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee9.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.MountedPathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebInfConfiguration.class);
    public static final String TEMPORARY_RESOURCE_BASE = "org.eclipse.jetty.webapp.tmpResourceBase";
    protected Resource _preUnpackBaseResource;

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.resolveTempDirectory(context);
        context.getCoreContextHandler().createTempDirectory();
        this.unpack(context);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory() && context.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = webInf.resolve("classes/");
            if (Resources.isReadableDirectory((Resource)classes)) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classes);
            }
            if (Resources.isReadableDirectory((Resource)(lib = webInf.resolve("lib/")))) {
                ((WebAppClassLoader)context.getClassLoader()).addJars(lib);
            }
        }
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        context.setBaseResource(this._preUnpackBaseResource);
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        Path tmpDir = Files.createTempDirectory(template.getTempDirectory().getParentFile().toPath(), WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context), new FileAttribute[0]);
        File tmpDirAsFile = tmpDir.toFile();
        tmpDirAsFile.deleteOnExit();
        context.setTempDirectory(tmpDirAsFile);
    }

    public void resolveTempDirectory(WebAppContext context) throws Exception {
        File tempDirectory = context.getTempDirectory();
        if (tempDirectory != null) {
            return;
        }
        File servletTmpDir = IO.asFile((Object)context.getAttribute("jakarta.servlet.context.tempdir"));
        if (servletTmpDir != null) {
            tempDirectory = servletTmpDir;
            context.setTempDirectory(tempDirectory);
            return;
        }
        context.makeTempDirectory();
    }

    @Deprecated(forRemoval=true, since="12.0.12")
    public void makeTempDirectory(File parent, WebAppContext context) throws Exception {
        context.makeTempDirectory();
    }

    public void unpack(WebAppContext context) throws IOException {
        Resource webApp = context.getBaseResource();
        this._preUnpackBaseResource = context.getBaseResource();
        if (webApp == null) {
            Resource jarWebApp;
            String war = context.getWar();
            webApp = war != null && war.length() > 0 ? context.newResource(war) : context.getBaseResource();
            if (webApp == null) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            if (webApp.isAlias()) {
                Resource realWebApp;
                URI realURI = webApp.getRealURI();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} anti-aliased to {}", (Object)webApp, (Object)realURI);
                }
                if ((realWebApp = context.newResource(realURI)) != null && realWebApp.exists()) {
                    webApp = realWebApp;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try webapp={} exists={} directory={} file={}", new Object[]{webApp, webApp.exists(), webApp.isDirectory(), webApp.getPath()});
            }
            Resource originalWarResource = webApp;
            if (Resources.isReadableFile((Resource)webApp) && FileID.isArchive((URI)webApp.getURI()) && !webApp.getURI().getScheme().equalsIgnoreCase("jar") && Resources.isDirectory((Resource)(jarWebApp = context.getResourceFactory().newJarFileResource(webApp.getURI())))) {
                webApp = jarWebApp;
            }
            if (webApp.exists() && (context.isCopyWebDir() && webApp.getPath() != null && originalWarResource.isDirectory() || context.isExtractWAR() && webApp.getPath() != null && !originalWarResource.isDirectory() || context.isExtractWAR() && webApp.getPath() == null || !webApp.isDirectory())) {
                Path sibling;
                Path warPath;
                Path extractedWebAppDir = null;
                if (war != null && FileID.isWebArchive((Path)(warPath = Path.of(war, new String[0]))) && Files.exists(warPath, new LinkOption[0]) && Files.exists(sibling = warPath.getParent().resolve(FileID.getBasename((Path)warPath)), new LinkOption[0]) && Files.isDirectory(sibling, new LinkOption[0]) && Files.isWritable(sibling)) {
                    extractedWebAppDir = sibling;
                }
                if (extractedWebAppDir == null) {
                    extractedWebAppDir = context.getTempDirectory().toPath().resolve("webapp");
                    context.setAttribute(TEMPORARY_RESOURCE_BASE, extractedWebAppDir);
                }
                if (webApp.getPath() != null && webApp.isDirectory()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copy {} to  {}", (Object)webApp, (Object)extractedWebAppDir);
                    }
                    webApp.copyTo(extractedWebAppDir);
                } else {
                    File extractionLock = new File(context.getTempDirectory(), ".extract_lock");
                    if (!Files.exists(extractedWebAppDir, new LinkOption[0])) {
                        extractionLock.createNewFile();
                        Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    } else if (originalWarResource.lastModified().isAfter(Files.getLastModifiedTime(extractedWebAppDir, new LinkOption[0]).toInstant()) || extractionLock.exists()) {
                        extractionLock.createNewFile();
                        if (IO.delete((Path)extractedWebAppDir)) {
                            Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        } else if (LOG.isInfoEnabled()) {
                            LOG.info("Unable to delete path {}, reusing existing path", (Object)extractedWebAppDir);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    }
                }
                webApp = context.getResourceFactory().newResource(extractedWebAppDir.normalize());
            }
            if (Resources.missing((Resource)webApp)) {
                LOG.warn("Web application not found {}", (Object)war);
                throw new FileNotFoundException(war);
            }
            context.setBaseResource(webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("webapp={}", (Object)webApp);
            }
        }
        if (context.isCopyWebInf() && !context.isCopyWebDir()) {
            Resource webInf = webApp.resolve("WEB-INF/");
            if (Resources.isReadableDirectory((Resource)webInf)) {
                Resource webInfClasses;
                File extractedWebInfDir = new File(context.getTempDirectory(), "webinf");
                if (extractedWebInfDir.exists()) {
                    IO.delete((File)extractedWebInfDir);
                }
                extractedWebInfDir.mkdir();
                File webInfDir = new File(extractedWebInfDir, "WEB-INF");
                webInfDir.mkdir();
                Resource webInfLib = webInf.resolve("lib/");
                if (Resources.isReadableDirectory((Resource)webInfLib)) {
                    File webInfLibDir = new File(webInfDir, "lib");
                    if (webInfLibDir.exists()) {
                        IO.delete((File)webInfLibDir);
                    }
                    webInfLibDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/lib {} to {}", (Object)webInfLib, (Object)webInfLibDir);
                    }
                    webInfLib.copyTo(webInfLibDir.toPath());
                }
                if (Resources.isReadableDirectory((Resource)(webInfClasses = webInf.resolve("classes/")))) {
                    File webInfClassesDir = new File(webInfDir, "classes");
                    if (webInfClassesDir.exists()) {
                        IO.delete((File)webInfClassesDir);
                    }
                    webInfClassesDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/classes from {} to {}", (Object)webInfClasses, (Object)webInfClassesDir.getAbsolutePath());
                    }
                    webInfClasses.copyTo(webInfClassesDir.toPath());
                }
                webInf = context.getResourceFactory().newResource(extractedWebInfDir.getCanonicalPath());
            }
            Resource rc = ResourceFactory.combine((Resource[])new Resource[]{webInf, webApp});
            if (LOG.isDebugEnabled()) {
                LOG.debug("context.baseResource={}", (Object)rc);
            }
            context.setBaseResource(rc);
        }
    }

    public static String getCanonicalNameForWebAppTmpDir(WebAppContext context) {
        return context.getCanonicalNameForTmpDir();
    }

    @Deprecated(forRemoval=true, since="12.0.12")
    protected static String getResourceBaseName(Resource resource) {
        Path resourceFile = resource.getPath();
        if (resourceFile != null && resource instanceof MountedPathResource) {
            resourceFile = ((MountedPathResource)resource).getContainerPath();
        }
        if (resourceFile != null) {
            Path fileName = resourceFile.getFileName();
            return fileName == null ? "" : fileName.toString();
        }
        URI uri = resource.getURI();
        if (uri == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource has no URI reference: {}", (Object)resource);
            }
            return "";
        }
        return URIUtil.getUriLastPathSegment((URI)uri);
    }
}

