/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.util.Objects;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public abstract class AbstractMessageSink
implements MessageSink {
    private final CoreSession session;
    private final MethodHolder methodHandle;
    private final boolean autoDemand;

    public AbstractMessageSink(CoreSession session, MethodHolder methodHolder, boolean autoDemand) {
        this.session = Objects.requireNonNull(session, "CoreSession");
        this.methodHandle = Objects.requireNonNull(methodHolder, "MethodHolder");
        this.autoDemand = autoDemand;
    }

    public CoreSession getCoreSession() {
        return this.session;
    }

    public MethodHolder getMethodHolder() {
        return this.methodHandle;
    }

    public boolean isAutoDemand() {
        return this.autoDemand;
    }

    protected void autoDemand() {
        if (this.isAutoDemand()) {
            this.getCoreSession().demand();
        }
    }
}

