/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested.resource;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jetty.ee9.nested.resource.ByteBufferRangeWriter;
import org.eclipse.jetty.ee9.nested.resource.InputStreamRangeWriter;
import org.eclipse.jetty.ee9.nested.resource.RangeWriter;
import org.eclipse.jetty.ee9.nested.resource.SeekableByteChannelRangeWriter;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.io.IOResources;

public class HttpContentRangeWriter {
    public static RangeWriter newRangeWriter(HttpContent content) {
        Objects.requireNonNull(content, "HttpContent");
        ByteBuffer buffer = content.getByteBuffer();
        if (buffer != null) {
            return new ByteBufferRangeWriter(buffer);
        }
        Path path = content.getResource().getPath();
        if (path != null) {
            return new SeekableByteChannelRangeWriter(() -> Files.newByteChannel(path, new OpenOption[0]));
        }
        return new InputStreamRangeWriter(() -> IOResources.asInputStream(content.getResource()));
    }
}

