/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.apache.jsp;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.jasper.servlet.TldScanner;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.eclipse.jetty.ee9.apache.jsp.JettyTldPreScanned;
import org.xml.sax.SAXException;

public class JettyJasperInitializer
extends JasperInitializer {
    private static final Log LOG = LogFactory.getLog(JasperInitializer.class);

    @Override
    public TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        String tmp = context.getInitParameter("org.eclipse.jetty.ee9.jsp.precompiled");
        if (tmp != null && !tmp.isEmpty() && Boolean.valueOf(tmp).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Jsp precompilation detected");
            }
            return new NullTldScanner(context, namespaceAware, validate, blockExternal);
        }
        Collection tldUrls = (Collection)context.getAttribute("org.eclipse.jetty.tlds");
        if (tldUrls != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tld pre-scan detected");
            }
            return new JettyTldPreScanned(context, namespaceAware, validate, blockExternal, tldUrls);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Defaulting to jasper tld scanning");
        }
        return super.newTldScanner(context, namespaceAware, validate, blockExternal);
    }

    private final class NullTldScanner
    extends TldScanner {
        private NullTldScanner(ServletContext context, boolean namespaceAware, boolean validation, boolean blockExternal) {
            super(context, namespaceAware, validation, blockExternal);
        }

        @Override
        public void scan() throws IOException, SAXException {
        }

        @Override
        public List<String> getListeners() {
            return Collections.emptyList();
        }

        @Override
        public void scanJars() {
        }
    }
}

