/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee9.nested.AsyncContextEvent;
import org.eclipse.jetty.ee9.nested.AsyncContextState;
import org.eclipse.jetty.ee9.nested.Authentication;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.Dispatcher;
import org.eclipse.jetty.ee9.nested.HttpChannel;
import org.eclipse.jetty.ee9.nested.HttpChannelState;
import org.eclipse.jetty.ee9.nested.HttpInput;
import org.eclipse.jetty.ee9.nested.MultiPart;
import org.eclipse.jetty.ee9.nested.PushBuilderImpl;
import org.eclipse.jetty.ee9.nested.Response;
import org.eclipse.jetty.ee9.nested.ServletAttributes;
import org.eclipse.jetty.ee9.nested.ServletPathMapping;
import org.eclipse.jetty.ee9.nested.UserIdentityScope;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceUtils;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartCompliance;
import org.eclipse.jetty.http.SetCookieParser;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.CookieCache;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request
implements HttpServletRequest {
    public static final String MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    @Deprecated
    public static final String __MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    public static final String SSL_CIPHER_SUITE = "jakarta.servlet.request.cipher_suite";
    public static final String SSL_KEY_SIZE = "jakarta.servlet.request.key_size";
    public static final String SSL_SESSION_ID = "jakarta.servlet.request.ssl_session_id";
    public static final String PEER_CERTIFICATES = "jakarta.servlet.request.X509Certificate";
    private static final Logger LOG = LoggerFactory.getLogger(Request.class);
    private static final SetCookieParser SET_COOKIE_PARSER = SetCookieParser.newInstance();
    private static final Collection<Locale> __defaultLocale = Collections.singleton(Locale.getDefault());
    private static final int INPUT_NONE = 0;
    private static final int INPUT_STREAM = 1;
    private static final int INPUT_READER = 2;
    private static final Fields NO_PARAMS = Fields.EMPTY;
    private static final Fields BAD_PARAMS = new Fields(true);
    private final HttpChannel _channel;
    private ContextHandler.APIContext _context;
    private final List<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
    private final HttpInput _input;
    private final boolean _crossContextDispatchSupported;
    private ContextHandler.CoreContextRequest _coreRequest;
    private MetaData.Request _metaData;
    private HttpFields _httpFields;
    private HttpFields _trailers;
    private HttpURI _uri;
    private String _method;
    private String _pathInContext;
    private ServletPathMapping _servletPathMapping;
    private Object _asyncNotSupportedSource = null;
    private boolean _secure;
    private boolean _handled = false;
    private Attributes _attributes;
    private Authentication _authentication;
    private String _contentType;
    private String _characterEncoding;
    private DispatcherType _dispatcherType;
    private int _inputState = 0;
    private BufferedReader _reader;
    private String _readerEncoding;
    private Fields _queryParameters;
    private Fields _contentParameters;
    private Fields _parameters;
    private Charset _queryEncoding;
    private UserIdentityScope _scope;
    private long _timeStamp;
    private MultiPart.Parser _multiParts;
    private AsyncContextState _async;
    private String _lastPathInContext;
    private ContextHandler.APIContext _lastContext;
    private static final EnumSet<HttpHeader> NOT_PUSHED_HEADERS = EnumSet.of(HttpHeader.IF_MATCH, new HttpHeader[]{HttpHeader.IF_RANGE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.RANGE, HttpHeader.EXPECT, HttpHeader.REFERER, HttpHeader.COOKIE, HttpHeader.AUTHORIZATION, HttpHeader.IF_NONE_MATCH, HttpHeader.IF_MODIFIED_SINCE});

    private static boolean isNoParams(Fields inputParameters) {
        boolean isNoParams = inputParameters == NO_PARAMS;
        return isNoParams;
    }

    public static Request getBaseRequest(ServletRequest request) {
        if (request instanceof Request) {
            return (Request)request;
        }
        Object channel = request.getAttribute(HttpChannel.class.getName());
        if (channel instanceof HttpChannel) {
            return ((HttpChannel)channel).getRequest();
        }
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        if (request instanceof Request) {
            return (Request)request;
        }
        return null;
    }

    public Request(HttpChannel channel, HttpInput input) {
        this._channel = channel;
        this._input = input;
        this._crossContextDispatchSupported = this._channel.getContextHandler().getCoreContextHandler().isCrossContextDispatchSupported();
    }

    public HttpFields getHttpFields() {
        return this._httpFields;
    }

    public void setHttpFields(HttpFields fields) {
        this._httpFields = fields.asImmutable();
    }

    public Map<String, String> getTrailerFields() {
        HttpFields trailersFields = this.getTrailerHttpFields();
        if (trailersFields == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> trailers = new HashMap<String, String>();
        for (HttpField field : trailersFields) {
            String key = field.getLowerCaseName();
            trailers.merge(key, field.getValue(), (existing, value) -> existing + "," + value);
        }
        return trailers;
    }

    public void setTrailerHttpFields(HttpFields trailers) {
        this._trailers = trailers == null ? null : trailers.asImmutable();
    }

    public HttpFields getTrailerHttpFields() {
        return this._trailers;
    }

    public HttpInput getHttpInput() {
        return this._input;
    }

    public boolean isPush() {
        return Boolean.TRUE.equals(this.getAttribute("org.eclipse.jetty.pushed"));
    }

    public boolean isPushSupported() {
        return !this.isPush() && this.getCoreRequest().getConnectionMetaData().isPushSupported();
    }

    public PushBuilder newPushBuilder() {
        String id;
        if (!this.isPushSupported()) {
            return null;
        }
        HttpFields.Mutable fields = HttpFields.build((HttpFields)this.getHttpFields(), NOT_PUSHED_HEADERS);
        HttpField authField = this.getHttpFields().getField(HttpHeader.AUTHORIZATION);
        if (authField != null && this.getUserPrincipal() != null && authField.getValue().startsWith("Basic")) {
            fields.add(authField);
        }
        try {
            HttpSession session = this.getSession(false);
            if (session != null) {
                session.getLastAccessedTime();
                id = session.getId();
            } else {
                id = this.getRequestedSessionId();
            }
        }
        catch (IllegalStateException e) {
            id = this.getRequestedSessionId();
        }
        StringBuilder cookieBuilder = new StringBuilder();
        Cookie[] cookies = this.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieBuilder.isEmpty()) {
                    cookieBuilder.append("; ");
                }
                cookieBuilder.append(cookie.getName()).append("=").append(cookie.getValue());
            }
        }
        for (HttpField field : this.getResponse().getHttpFields()) {
            HttpCookie httpCookie;
            HttpHeader header = field.getHeader();
            if (header != HttpHeader.SET_COOKIE && header != HttpHeader.SET_COOKIE2) continue;
            if (field instanceof HttpCookieUtils.SetCookieHttpField) {
                HttpCookieUtils.SetCookieHttpField set = (HttpCookieUtils.SetCookieHttpField)field;
                httpCookie = set.getHttpCookie();
            } else {
                httpCookie = SET_COOKIE_PARSER.parse(field.getValue());
            }
            if (httpCookie == null || httpCookie.isExpired()) continue;
            if (!cookieBuilder.isEmpty()) {
                cookieBuilder.append("; ");
            }
            cookieBuilder.append(httpCookie.getName()).append("=").append(httpCookie.getValue());
        }
        if (!cookieBuilder.isEmpty()) {
            fields.put(HttpHeader.COOKIE, cookieBuilder.toString());
        }
        String query = this.getQueryString();
        PushBuilderImpl builder = new PushBuilderImpl(this, (HttpFields)fields, this.getMethod(), query, id);
        Object referrer = this.getRequestURL().toString();
        if (query != null) {
            referrer = (String)referrer + "?" + query;
        }
        builder.addHeader("referer", (String)referrer);
        return builder;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listener);
        }
        if (listener instanceof AsyncListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
    }

    Fields peekParameters() {
        return this._parameters;
    }

    private Fields getParameters() {
        Fields parameters = this._parameters;
        if (parameters == null) {
            if (this._contentParameters == null) {
                try {
                    this.extractContentParameters();
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    LOG.warn(e.toString());
                    throw new BadMessageException("Unable to parse form content", (Throwable)e);
                }
            }
            if (this._queryParameters == null) {
                this.extractQueryParameters();
            }
            if (Request.isNoParams(this._queryParameters) || this._queryParameters.getSize() == 0) {
                this._parameters = this._contentParameters;
            } else if (Request.isNoParams(this._contentParameters) || this._contentParameters.getSize() == 0) {
                this._parameters = this._queryParameters;
            } else if (this._parameters == null) {
                this._parameters = new Fields(true);
                this._parameters.addAll(this._queryParameters);
                this._parameters.addAll(this._contentParameters);
            }
            parameters = this._parameters;
        }
        return parameters == null ? NO_PARAMS : parameters;
    }

    private void extractQueryParameters() {
        String sourceQuery;
        String dispatcherType;
        if (this._uri == null) {
            this._queryParameters = NO_PARAMS;
            return;
        }
        String query = this._uri.getQuery();
        if (StringUtil.isEmpty((String)query)) {
            this._queryParameters = NO_PARAMS;
        } else {
            try {
                this._queryParameters = new Fields(true);
                if (StandardCharsets.UTF_8.equals(this._queryEncoding) || this._queryEncoding == null && UrlEncoded.ENCODING.equals(StandardCharsets.UTF_8)) {
                    HttpConfiguration httpConfiguration = this.getHttpChannel().getHttpConfiguration();
                    ComplianceViolation.Listener complianceViolationListener = this.getHttpChannel().getRequest().getComplianceViolationListener();
                    UriCompliance uriCompliance = httpConfiguration.getUriCompliance();
                    boolean allowBadPercent = uriCompliance.allows((ComplianceViolation)UriCompliance.Violation.BAD_PERCENT_ENCODING);
                    boolean allowBadUtf8 = uriCompliance.allows((ComplianceViolation)UriCompliance.Violation.BAD_UTF8_ENCODING);
                    boolean allowTruncatedUtf8 = uriCompliance.allows((ComplianceViolation)UriCompliance.Violation.TRUNCATED_UTF8_ENCODING);
                    BiConsumer<String, Boolean> onBadEncodingConsumer = (cause, allowed) -> {
                        ComplianceUtils.notify((ComplianceViolation.Listener)complianceViolationListener, (ComplianceViolation.Event)new ComplianceViolation.Event((ComplianceViolation.Mode)uriCompliance, (ComplianceViolation)UriCompliance.Violation.BAD_UTF8_ENCODING, cause, allowed.booleanValue()));
                        if (!allowed.booleanValue()) {
                            throw new HttpException.IllegalArgumentException(400, "Bad query");
                        }
                    };
                    BiConsumer<String, Boolean> onBadPercentConsumer = (cause, allowed) -> {
                        ComplianceUtils.notify((ComplianceViolation.Listener)complianceViolationListener, (ComplianceViolation.Event)new ComplianceViolation.Event((ComplianceViolation.Mode)uriCompliance, (ComplianceViolation)UriCompliance.Violation.BAD_PERCENT_ENCODING, cause, allowed.booleanValue()));
                        if (!allowed.booleanValue()) {
                            throw new HttpException.IllegalArgumentException(400, "Bad query");
                        }
                    };
                    BiConsumer<String, Boolean> onTruncatedEncodingConsumer = (cause, allowed) -> {
                        ComplianceUtils.notify((ComplianceViolation.Listener)complianceViolationListener, (ComplianceViolation.Event)new ComplianceViolation.Event((ComplianceViolation.Mode)uriCompliance, (ComplianceViolation)UriCompliance.Violation.TRUNCATED_UTF8_ENCODING, cause, allowed.booleanValue()));
                        if (!allowed.booleanValue()) {
                            throw new HttpException.IllegalArgumentException(400, "Bad query");
                        }
                    };
                    UrlEncoded.decodeUtf8To((String)query, (int)0, (int)query.length(), (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (boolean)allowBadPercent, (boolean)allowBadUtf8, (boolean)allowTruncatedUtf8, onBadEncodingConsumer, onBadPercentConsumer, onTruncatedEncodingConsumer);
                } else {
                    UrlEncoded.decodeTo((String)query, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this._queryEncoding);
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                this._queryParameters = BAD_PARAMS;
                throw new BadMessageException("Unable to parse URI query", (Throwable)e);
            }
        }
        if (this._crossContextDispatchSupported && (dispatcherType = this._coreRequest.getContext().getCrossContextDispatchType((org.eclipse.jetty.server.Request)this._coreRequest)) != null && !StringUtil.isBlank((String)(sourceQuery = (String)this._coreRequest.getAttribute(DispatcherType.valueOf((String)dispatcherType) == DispatcherType.FORWARD ? "jakarta.servlet.forward.query_string" : "org.eclipse.jetty.dispatch.originalQueryString")))) {
            if (this._queryParameters == NO_PARAMS) {
                this._queryParameters = new Fields(true);
            }
            UrlEncoded.decodeTo((String)sourceQuery, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this._queryEncoding);
        }
    }

    private boolean isContentEncodingSupported() {
        String contentEncoding = this.getHttpFields().get(HttpHeader.CONTENT_ENCODING);
        if (contentEncoding == null) {
            return true;
        }
        return HttpHeaderValue.IDENTITY.is(contentEncoding);
    }

    private void extractContentParameters() {
        String contentType = this.getContentType();
        if (contentType == null || contentType.isEmpty()) {
            this._contentParameters = NO_PARAMS;
        } else {
            if (this._crossContextDispatchSupported && this._coreRequest.getContext().isCrossContextDispatch((org.eclipse.jetty.server.Request)this._coreRequest)) {
                try {
                    this._contentParameters = FormFields.getFields((org.eclipse.jetty.server.Request)this._coreRequest);
                    return;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            this._contentParameters = new Fields(true);
            int contentLength = this.getContentLength();
            if (contentLength != 0 && this._inputState == 0) {
                String baseType = HttpField.getValueParameters((String)contentType, null);
                if (MimeTypes.Type.FORM_ENCODED.is(baseType) && this._channel.getHttpConfiguration().isFormEncodedMethod(this.getMethod())) {
                    if (this._metaData != null && !this.isContentEncodingSupported()) {
                        throw new BadMessageException(415, "Unsupported Content-Encoding");
                    }
                    this.extractFormParameters(this._contentParameters);
                } else if (MimeTypes.Type.MULTIPART_FORM_DATA.is(baseType) && this.getAttribute("org.eclipse.jetty.multipartConfig") != null && this._multiParts == null) {
                    try {
                        if (this._metaData != null && !this.isContentEncodingSupported()) {
                            throw new BadMessageException(415, "Unsupported Content-Encoding");
                        }
                        this.getParts(this._contentParameters);
                    }
                    catch (IOException e) {
                        String msg = "Unable to extract content parameters";
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(msg, (Throwable)e);
                        }
                        throw new BadMessageException(msg, (Throwable)e);
                    }
                }
            }
        }
    }

    public void extractFormParameters(Fields params) {
        try {
            int maxFormContentSize = 200000;
            int maxFormKeys = 1000;
            if (this._context != null) {
                ContextHandler contextHandler = this._context.getContextHandler();
                maxFormContentSize = contextHandler.getMaxFormContentSize();
                maxFormKeys = contextHandler.getMaxFormKeys();
            }
            int contentLength = this.getContentLength();
            if (maxFormContentSize >= 0 && contentLength > maxFormContentSize) {
                throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
            }
            ServletInputStream in = this.getInputStream();
            if (this._input.isAsync()) {
                throw new IllegalStateException("Cannot extract parameters with async IO");
            }
            UrlEncoded.decodeTo((InputStream)in, (arg_0, arg_1) -> ((Fields)params).add(arg_0, arg_1), (Charset)UrlEncoded.decodeCharset((String)this.getCharacterEncoding()), (int)maxFormContentSize, (int)maxFormKeys);
        }
        catch (IOException e) {
            String msg = "Unable to extract form parameters";
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg, (Throwable)e);
            }
            throw new UncheckedIOException(msg, e);
        }
    }

    private int lookupServerAttribute(String key, int dftValue) {
        Object attribute = this._channel.getServer().getAttribute(key);
        if (attribute instanceof Number) {
            return ((Number)attribute).intValue();
        }
        if (attribute instanceof String) {
            return Integer.parseInt((String)attribute);
        }
        return dftValue;
    }

    public AsyncContext getAsyncContext() {
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null || !state.isAsyncStarted()) {
            throw new IllegalStateException(state.getStatusString());
        }
        return this._async;
    }

    public HttpChannelState getHttpChannelState() {
        return this._channel.getState();
    }

    public ComplianceViolation.Listener getComplianceViolationListener() {
        return org.eclipse.jetty.server.HttpChannel.from((org.eclipse.jetty.server.Request)this.getCoreRequest()).getComplianceViolationListener();
    }

    public Object getAttribute(String name) {
        if (name.startsWith("org.eclipse.jetty")) {
            if (Server.class.getName().equals(name)) {
                return this._channel.getServer();
            }
            if (HttpChannel.class.getName().equals(name)) {
                return this._channel;
            }
            if (Connection.class.getName().equals(name)) {
                return this._channel.getCoreRequest().getConnectionMetaData().getConnection();
            }
            if (MultiPart.Parser.class.getName().equals(name)) {
                return this._multiParts;
            }
        }
        return this._attributes == null ? null : this._attributes.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return Collections.enumeration(this._attributes.getAttributeNameSet());
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public String getAuthType() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getAuthMethod();
        }
        return null;
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            String contentType;
            if (this._context != null) {
                this._characterEncoding = this._context.getRequestCharacterEncoding();
            }
            if (this._characterEncoding == null && (contentType = this.getContentType()) != null) {
                String charset;
                MimeTypes.Type mime = (MimeTypes.Type)MimeTypes.CACHE.get(contentType);
                String string = charset = mime == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType((String)contentType) : mime.getCharset().toString();
                if (charset != null) {
                    this._characterEncoding = charset;
                }
            }
        }
        return this._characterEncoding;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public int getContentLength() {
        long contentLength = this.getContentLengthLong();
        if (contentLength > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)contentLength;
    }

    public long getContentLengthLong() {
        if (this._httpFields == null) {
            return -1L;
        }
        return this._httpFields.getLongField(HttpHeader.CONTENT_LENGTH);
    }

    public long getContentRead() {
        return this._input.getContentReceived();
    }

    public String getContentType() {
        if (this._contentType == null) {
            MetaData.Request metadata = this._metaData;
            this._contentType = metadata == null ? null : metadata.getHttpFields().get(HttpHeader.CONTENT_TYPE);
        }
        return this._contentType;
    }

    public ContextHandler.APIContext getContext() {
        return this._context;
    }

    public void setContext(ContextHandler.APIContext context, String pathInContext) {
        this._context = context;
        this._pathInContext = pathInContext;
        if (context != null) {
            this._lastContext = context;
            this._lastPathInContext = pathInContext;
        }
    }

    public ContextHandler.APIContext getLastContext() {
        return this._lastContext;
    }

    public String getLastPathInContext() {
        return this._lastPathInContext;
    }

    public String getContextPath() {
        Dispatcher.IncludeAttributes include;
        ContextHandler.APIContext context;
        if (this._crossContextDispatchSupported) {
            String crossContextDispatchType = this._coreRequest.getContext().getCrossContextDispatchType((org.eclipse.jetty.server.Request)this._coreRequest);
            if (DispatcherType.INCLUDE.toString().equals(crossContextDispatchType)) {
                return (String)this._coreRequest.getAttribute("org.eclipse.jetty.dispatch.originalContextPath");
            }
        }
        if ((context = this._dispatcherType == DispatcherType.INCLUDE ? ((include = (Dispatcher.IncludeAttributes)Attributes.unwrap((Attributes)this._attributes, Dispatcher.IncludeAttributes.class)) == null ? this._context : include.getSourceContext()) : this._context) == null) {
            return null;
        }
        return context.getContextHandler().getRequestContextPath();
    }

    public String getPathInContext() {
        return this._pathInContext;
    }

    public Cookie[] getCookies() {
        return (Cookie[])CookieCache.getApiCookies((org.eclipse.jetty.server.Request)this.getCoreRequest(), Cookie.class, this::convertCookie);
    }

    private Cookie convertCookie(HttpCookie cookie) {
        try {
            Cookie result = new Cookie(cookie.getName(), cookie.getValue());
            if (this.getCoreRequest().getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance().allows((ComplianceViolation)CookieCompliance.Violation.ATTRIBUTE_VALUES)) {
                String comment;
                String domain;
                String path;
                if (cookie.getVersion() > 0) {
                    result.setVersion(cookie.getVersion());
                }
                if (StringUtil.isNotBlank((String)(path = cookie.getPath()))) {
                    result.setPath(path);
                }
                if (StringUtil.isNotBlank((String)(domain = cookie.getDomain()))) {
                    result.setDomain(domain);
                }
                if (StringUtil.isNotBlank((String)(comment = cookie.getComment()))) {
                    result.setComment(comment);
                }
            }
            return result;
        }
        catch (Exception x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause((Throwable)x).log("Bad Cookie");
            }
            return null;
        }
    }

    public long getDateHeader(String name) {
        HttpFields fields = this._httpFields;
        if (fields == null) {
            return -1L;
        }
        HttpField field = fields.getField(name);
        if (field == null) {
            return -1L;
        }
        long date = fields.getDateField(name);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot parse date");
        }
        return date;
    }

    public DispatcherType getDispatcherType() {
        return this._dispatcherType;
    }

    public String getHeader(String name) {
        HttpFields fields = this._httpFields;
        return fields == null ? null : fields.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        HttpFields fields = this._httpFields;
        return fields == null ? Collections.emptyEnumeration() : Collections.enumeration(fields.getFieldNamesCollection());
    }

    public Enumeration<String> getHeaders(String name) {
        HttpFields fields = this._httpFields;
        if (fields == null) {
            return Collections.emptyEnumeration();
        }
        Enumeration e = fields.getValues(name);
        if (e == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return e;
    }

    public int getInputState() {
        return this._inputState;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        if (this._inputState == 0 && this._coreRequest.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString())) {
            this._channel.getCoreResponse().writeInterim(100, HttpFields.EMPTY);
        }
        this._inputState = 1;
        return this._input;
    }

    public int getIntHeader(String name) {
        HttpFields fields = this._httpFields;
        return fields == null ? -1 : (int)fields.getLongField(name);
    }

    public Locale getLocale() {
        HttpFields fields = this._httpFields;
        if (fields == null) {
            return Locale.getDefault();
        }
        List<String> acceptable = fields.getQualityCSV(HttpHeader.ACCEPT_LANGUAGE).stream().filter(StringUtil::isNotBlank).toList();
        if (acceptable.isEmpty()) {
            return Locale.getDefault();
        }
        List<Locale> locales = acceptable.stream().map(Locale::forLanguageTag).toList();
        List<Locale> known = locales.stream().filter(MimeTypes::isKnownLocale).toList();
        if (known.isEmpty()) {
            return Locale.getDefault();
        }
        return known.get(0);
    }

    public Enumeration<Locale> getLocales() {
        HttpFields fields = this._httpFields;
        if (fields == null) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptable = fields.getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        if (acceptable.isEmpty()) {
            return Collections.enumeration(__defaultLocale);
        }
        List locales = acceptable.stream().map(language -> {
            language = HttpField.stripParameters((String)language);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale((String)language, country);
        }).collect(Collectors.toList());
        return Collections.enumeration(locales);
    }

    public String getLocalAddr() {
        if (this._channel != null) {
            InetSocketAddress local = this._channel.getLocalAddress();
            if (local == null) {
                return "";
            }
            InetAddress address = local.getAddress();
            String result = address == null ? local.getHostString() : address.getHostAddress();
            return HostPort.normalizeHost((String)result);
        }
        return "";
    }

    public String getLocalName() {
        if (this._channel != null) {
            String localName = this._channel.getLocalName();
            return HostPort.normalizeHost((String)localName);
        }
        return "";
    }

    public int getLocalPort() {
        return org.eclipse.jetty.server.Request.getLocalPort((org.eclipse.jetty.server.Request)this._channel.getCoreRequest());
    }

    public String getMethod() {
        return this._method;
    }

    public String getParameter(String name) {
        return this.getParameters().getValue(name);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.getParameters().toStringArrayMap());
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameters().getNames());
    }

    public String[] getParameterValues(String name) {
        List vals = this.getParameters().getValues(name);
        if (vals == null) {
            return null;
        }
        return vals.toArray(new String[0]);
    }

    @Deprecated
    public MultiMap<String> getQueryParameters() {
        return this._queryParameters == null ? null : this._queryParameters.toMultiMap();
    }

    public Fields getQueryFields() {
        return this._queryParameters;
    }

    public void setQueryFields(Fields queryParameters) {
        this._queryParameters = queryParameters;
    }

    @Deprecated
    public void setQueryParameters(MultiMap<String> queryParameters) {
        this._queryParameters = queryParameters == null ? null : new Fields(queryParameters);
    }

    public void setContentFields(Fields contentParameters) {
        this._contentParameters = contentParameters;
    }

    @Deprecated
    public void setContentParameters(MultiMap<String> contentParameters) {
        this._contentParameters = contentParameters == null ? NO_PARAMS : new Fields(contentParameters);
    }

    public void resetParameters() {
        this._parameters = null;
    }

    public String getPathInfo() {
        ServletPathMapping mapping = this.findServletPathMapping();
        return mapping == null ? this._pathInContext : mapping.getPathInfo();
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null || this._context == null) {
            return null;
        }
        return this._context.getRealPath(pathInfo);
    }

    public String getProtocol() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        HttpVersion version = metadata.getHttpVersion();
        if (version == null) {
            return null;
        }
        return version.toString();
    }

    public HttpVersion getHttpVersion() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getHttpVersion();
    }

    public String getQueryEncoding() {
        return this._queryEncoding == null ? null : this._queryEncoding.name();
    }

    Charset getQueryCharset() {
        return this._queryEncoding;
    }

    public String getQueryString() {
        if (this._crossContextDispatchSupported) {
            String crossContextDispatchType = this._coreRequest.getContext().getCrossContextDispatchType((org.eclipse.jetty.server.Request)this._coreRequest);
            if (DispatcherType.INCLUDE.toString().equals(crossContextDispatchType)) {
                return (String)this._coreRequest.getAttribute("org.eclipse.jetty.dispatch.originalQueryString");
            }
        }
        return this._uri == null ? null : this._uri.getQuery();
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = MimeTypes.ISO_8859_1;
        }
        if (this._reader != null && encoding.equalsIgnoreCase(this._readerEncoding)) {
            if (this._inputState == 0 && this._coreRequest.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString())) {
                this._channel.getCoreResponse().writeInterim(100, HttpFields.EMPTY);
            }
        } else {
            final ServletInputStream in = this.getInputStream();
            this._readerEncoding = encoding;
            this._reader = new BufferedReader(this, new InputStreamReader((InputStream)in, encoding)){
                final /* synthetic */ Request this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void close() throws IOException {
                    in.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    @Deprecated(since="Servlet API 2.1")
    public String getRealPath(String path) {
        if (this._context == null) {
            return null;
        }
        return this._context.getRealPath(path);
    }

    public InetSocketAddress getRemoteInetSocketAddress() {
        InetSocketAddress inetSocketAddr;
        SocketAddress socketAddress = this._channel.getCoreRequest().getConnectionMetaData().getRemoteSocketAddress();
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddr = (InetSocketAddress)socketAddress) : null;
    }

    public String getRemoteAddr() {
        return org.eclipse.jetty.server.Request.getRemoteAddr((org.eclipse.jetty.server.Request)this._channel.getCoreRequest());
    }

    public String getRemoteHost() {
        SocketAddress remote = this._channel.getCoreRequest().getConnectionMetaData().getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remote;
            return inetSocketAddress.getHostString();
        }
        return remote.toString();
    }

    public int getRemotePort() {
        return org.eclipse.jetty.server.Request.getRemotePort((org.eclipse.jetty.server.Request)this._channel.getCoreRequest());
    }

    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || this._context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = this._pathInContext;
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths((String)relTo, (String)path);
        }
        return this._context.getRequestDispatcher(path);
    }

    public String getRequestedSessionId() {
        AbstractSessionManager.RequestedSession requestedSession = this._coreRequest.getRequestedSession();
        return requestedSession == null ? null : requestedSession.sessionId();
    }

    public String getRequestURI() {
        if (this._crossContextDispatchSupported) {
            String crossContextDispatchType = this._coreRequest.getContext().getCrossContextDispatchType((org.eclipse.jetty.server.Request)this._coreRequest);
            if (DispatcherType.INCLUDE.toString().equals(crossContextDispatchType)) {
                return (String)this._coreRequest.getAttribute("org.eclipse.jetty.dispatch.originalURI");
            }
        }
        return this._uri == null ? null : this._uri.getPath();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(128);
        URIUtil.appendSchemeHostPort((StringBuffer)url, (String)this.getScheme(), (String)this.getServerName(), (int)this.getServerPort());
        String path = this.getRequestURI();
        if (path != null) {
            url.append(path);
        }
        return url;
    }

    public Response getResponse() {
        return this._channel.getResponse();
    }

    public StringBuilder getRootURL() {
        return new StringBuilder(HttpURI.from((String)this.getScheme(), (String)this.getServerName(), (int)this.getServerPort(), null).asString());
    }

    public String getScheme() {
        return this._uri == null ? "http" : this._uri.getScheme();
    }

    public String getServerName() {
        if (this._uri != null && StringUtil.isNotBlank((String)this._uri.getAuthority())) {
            return HostPort.normalizeHost((String)this._uri.getHost());
        }
        return this.findServerName();
    }

    private String findServerName() {
        HostPort serverAuthority;
        if (this._channel != null && (serverAuthority = this._channel.getServerAuthority()) != null) {
            return HostPort.normalizeHost((String)serverAuthority.getHost());
        }
        String name = this.getLocalName();
        if (name != null) {
            return HostPort.normalizeHost((String)name);
        }
        return "";
    }

    public int getServerPort() {
        return org.eclipse.jetty.server.Request.getServerPort((org.eclipse.jetty.server.Request)this.getCoreRequest());
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public String getServletName() {
        if (this._scope != null) {
            return this._scope.getName();
        }
        return null;
    }

    public String getServletPath() {
        ServletPathMapping mapping = this.findServletPathMapping();
        return mapping == null ? "" : mapping.getServletPath();
    }

    public ServletResponse getServletResponse() {
        return this._channel.getResponse();
    }

    public String changeSessionId() {
        String newId = this._coreRequest.changeSessionId();
        if (newId != null && this.getRemoteUser() != null) {
            this._coreRequest.getManagedSession().setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return newId;
    }

    public void onCompleted() {
        this._input.consumeAll();
        if (this._multiParts != null) {
            try {
                if (!this._crossContextDispatchSupported || !this._coreRequest.getContext().isCrossContextDispatch((org.eclipse.jetty.server.Request)this._coreRequest)) {
                    this._multiParts.deleteParts();
                }
            }
            catch (Throwable e) {
                LOG.warn("Errors deleting multipart tmp files", e);
            }
        }
    }

    public HttpSession getSession(SessionManager sessionManager) {
        ManagedSession managedSession = this._coreRequest.getManagedSession();
        if (managedSession != null && managedSession.getSessionManager() == sessionManager) {
            return (HttpSession)managedSession.getApi();
        }
        return null;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        Session session = this._coreRequest.getSession(create);
        if (session != null && session.isNew() && this.getAuthentication() instanceof Authentication.User) {
            session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return session == null ? null : (HttpSession)session.getApi();
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public HttpURI getHttpURI() {
        return this._uri;
    }

    public void setHttpURI(HttpURI uri) {
        if (this._uri != null && !Objects.equals(this._uri.getQuery(), uri.getQuery()) && this._queryParameters != BAD_PARAMS) {
            this._queryParameters = null;
            this._parameters = null;
        }
        this._uri = uri.asImmutable();
    }

    public String getOriginalURI() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        HttpURI uri = metadata.getHttpURI();
        if (uri == null) {
            return null;
        }
        return uri.isAbsolute() && metadata.getHttpVersion() == HttpVersion.HTTP_2 ? uri.getPathQuery() : uri.toString();
    }

    public UserIdentity getUserIdentity() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity getResolvedUserIdentity() {
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentityScope getUserIdentityScope() {
        return this._scope;
    }

    public Principal getUserPrincipal() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            UserIdentity user = ((Authentication.User)this._authentication).getUserIdentity();
            return user.getUserPrincipal();
        }
        return null;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public boolean isAsyncStarted() {
        return this.getHttpChannelState().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._asyncNotSupportedSource == null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._coreRequest.getRequestedSession().isSessionIdFrom("cookie");
    }

    @Deprecated(since="Servlet API 2.1")
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._coreRequest.getRequestedSession().isSessionIdFrom("uri");
    }

    public boolean isRequestedSessionIdValid() {
        AbstractSessionManager.RequestedSession requestedSession = this._coreRequest.getRequestedSession();
        SessionManager sessionManager = this._coreRequest.getSessionManager();
        ManagedSession managedSession = this._coreRequest.getManagedSession();
        return requestedSession != null && sessionManager != null && managedSession != null && requestedSession.sessionId() != null && requestedSession.session() != null && requestedSession.session().isValid() && sessionManager.getSessionIdManager().getId(requestedSession.sessionId()).equals(managedSession.getId());
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public long getBeginNanoTime() {
        return this._metaData.getBeginNanoTime();
    }

    public boolean isUserInRole(String role) {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).isUserInRole(this._scope, role);
        }
        return false;
    }

    void onRequest(ContextHandler.CoreContextRequest coreRequest) {
        this._input.reopen();
        this._channel.getResponse().getHttpOutput().reopen();
        this._coreRequest = coreRequest;
        this.setTimeStamp(org.eclipse.jetty.server.Request.getTimeStamp((org.eclipse.jetty.server.Request)coreRequest));
        this._metaData = new MetaData.Request(coreRequest.getBeginNanoTime(), coreRequest.getMethod(), coreRequest.getHttpURI(), coreRequest.getConnectionMetaData().getHttpVersion(), coreRequest.getHeaders());
        this._attributes = new ServletAttributes((Attributes)coreRequest);
        this._method = coreRequest.getMethod();
        this._uri = coreRequest.getHttpURI();
        this._httpFields = coreRequest.getHeaders();
        this._pathInContext = URIUtil.decodePath((String)coreRequest.getHttpURI().getCanonicalPath());
        this.setSecure(coreRequest.isSecure());
    }

    public ContextHandler.CoreContextRequest getCoreRequest() {
        return this._coreRequest;
    }

    public MetaData.Request getMetaData() {
        return this._metaData;
    }

    public boolean hasMetaData() {
        return this._metaData != null;
    }

    protected void recycle() {
        if (this._reader != null && this._inputState == 2) {
            try {
                int r = this._reader.read();
                while (r != -1) {
                    r = this._reader.read();
                }
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
                this._reader = null;
                this._readerEncoding = null;
            }
        }
        this.getHttpChannelState().recycle();
        this._requestAttributeListeners.clear();
        this._input.recycle();
        this._coreRequest = null;
        this._metaData = null;
        this._httpFields = null;
        this._trailers = null;
        this._uri = null;
        this._method = null;
        this._pathInContext = null;
        this._servletPathMapping = null;
        this._asyncNotSupportedSource = null;
        this._secure = false;
        this._handled = false;
        this._attributes = null;
        this._authentication = Authentication.NOT_CHECKED;
        this._contentType = null;
        this._characterEncoding = null;
        this._dispatcherType = null;
        this._inputState = 0;
        this._queryParameters = null;
        this._contentParameters = null;
        this._parameters = null;
        this._queryEncoding = null;
        this._scope = null;
        this._timeStamp = 0L;
        this._multiParts = null;
        if (this._async != null) {
            this._async.reset();
        }
        this._async = null;
    }

    public void removeAttribute(String name) {
        Object oldValue;
        Object object = oldValue = this._attributes == null ? null : this._attributes.getAttribute(name);
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
        if (oldValue != null && !this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, oldValue);
            for (ServletRequestAttributeListener listener : this._requestAttributeListeners) {
                listener.attributeRemoved(event);
            }
        }
    }

    public void removeEventListener(EventListener listener) {
        this._requestAttributeListeners.remove(listener);
    }

    public void setAsyncSupported(boolean supported, Object source) {
        this._asyncNotSupportedSource = supported ? null : (source == null ? "unknown" : source);
    }

    public void setAttribute(String name, Object value) {
        if (this._attributes == null) {
            return;
        }
        switch (name) {
            case "org.eclipse.jetty.server.Request.queryEncoding": {
                this.setQueryEncoding(value == null ? null : value.toString());
                break;
            }
            case "org.eclipse.jetty.server.sendContent": {
                LOG.warn("Deprecated: org.eclipse.jetty.server.sendContent");
            }
        }
        Object oldValue = this._attributes.setAttribute(name, value);
        if (!this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, oldValue == null ? value : oldValue);
            for (ServletRequestAttributeListener l : this._requestAttributeListeners) {
                if (oldValue == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public void setAsyncAttributes() {
        if (this.getAttribute("jakarta.servlet.async.request_uri") != null) {
            return;
        }
        Attributes baseAttributes = Attributes.unwrap((Attributes)this._attributes);
        String fwdRequestURI = (String)this.getAttribute("jakarta.servlet.forward.request_uri");
        if (fwdRequestURI == null) {
            if (baseAttributes instanceof ServletAttributes) {
                ((ServletAttributes)baseAttributes).setAsyncAttributes(this.getRequestURI(), this.getContextPath(), this.getPathInContext(), this.getServletPathMapping(), this.getQueryString());
            } else {
                this._attributes.setAttribute("jakarta.servlet.async.request_uri", (Object)this.getRequestURI());
                this._attributes.setAttribute("jakarta.servlet.async.context_path", (Object)this.getContextPath());
                this._attributes.setAttribute("jakarta.servlet.async.servlet_path", (Object)this.getServletPath());
                this._attributes.setAttribute("jakarta.servlet.async.path_info", (Object)this.getPathInfo());
                this._attributes.setAttribute("jakarta.servlet.async.query_string", (Object)this.getQueryString());
                this._attributes.setAttribute("jakarta.servlet.async.mapping", (Object)this.getHttpServletMapping());
            }
        } else if (baseAttributes instanceof ServletAttributes) {
            ((ServletAttributes)baseAttributes).setAsyncAttributes(fwdRequestURI, (String)this.getAttribute("jakarta.servlet.forward.context_path"), (String)this.getAttribute("jakarta.servlet.forward.path_info"), (ServletPathMapping)this.getAttribute("jakarta.servlet.forward.mapping"), (String)this.getAttribute("jakarta.servlet.forward.query_string"));
        } else {
            this._attributes.setAttribute("jakarta.servlet.async.request_uri", (Object)fwdRequestURI);
            this._attributes.setAttribute("jakarta.servlet.async.context_path", this.getAttribute("jakarta.servlet.forward.context_path"));
            this._attributes.setAttribute("jakarta.servlet.async.servlet_path", this.getAttribute("jakarta.servlet.forward.servlet_path"));
            this._attributes.setAttribute("jakarta.servlet.async.path_info", this.getAttribute("jakarta.servlet.forward.path_info"));
            this._attributes.setAttribute("jakarta.servlet.async.query_string", this.getAttribute("jakarta.servlet.forward.query_string"));
            this._attributes.setAttribute("jakarta.servlet.async.mapping", this.getAttribute("jakarta.servlet.forward.mapping"));
        }
    }

    public void setAuthentication(Authentication authentication) {
        this._authentication = authentication;
        if (this._coreRequest != null) {
            org.eclipse.jetty.server.Request.setAuthenticationState((org.eclipse.jetty.server.Request)this._coreRequest, (Request.AuthenticationState)authentication);
        }
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        MimeTypes.getKnownCharset((String)encoding);
        this._characterEncoding = encoding;
    }

    public void setCharacterEncodingUnchecked(String encoding) {
        this._characterEncoding = encoding;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public void setDispatcherType(DispatcherType type) {
        this._dispatcherType = type;
    }

    public void setHandled(boolean h) {
        this._handled = h;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public boolean isHead() {
        return HttpMethod.HEAD.is(this.getMethod());
    }

    public void setQueryEncoding(String queryEncoding) {
        this._queryEncoding = Charset.forName(queryEncoding);
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public void setUserIdentityScope(UserIdentityScope scope) {
        this._scope = scope;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (this._asyncNotSupportedSource != null) {
            throw new IllegalStateException("!asyncSupported: " + String.valueOf(this._asyncNotSupportedSource));
        }
        return this.forceStartAsync();
    }

    private AsyncContextState forceStartAsync() {
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this._context, this._async, state, this, (ServletRequest)this, (ServletResponse)this.getResponse());
        state.startAsync(event);
        return this._async;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (this._asyncNotSupportedSource != null) {
            throw new IllegalStateException("!asyncSupported: " + String.valueOf(this._asyncNotSupportedSource));
        }
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this._context, this._async, state, this, servletRequest, servletResponse, this.getHttpURI());
        event.setDispatchPath(URIUtil.encodePath((String)Request.getBaseRequest(servletRequest).getPathInContext()));
        event.setDispatchContext(this.getServletContext());
        state.startAsync(event);
        return this._async;
    }

    public static HttpServletRequest unwrap(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequestWrapper) {
            return (HttpServletRequestWrapper)servletRequest;
        }
        if (servletRequest instanceof ServletRequestWrapper) {
            return Request.unwrap(((ServletRequestWrapper)servletRequest).getRequest());
        }
        return (HttpServletRequest)servletRequest;
    }

    public String toString() {
        return String.format("%s%s%s %s%s@%x", TypeUtil.toShortName(this.getClass()), this._handled ? "[" : "(", this.getMethod(), this.getHttpURI(), this._handled ? "]" : ")", this.hashCode());
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.getUserPrincipal() != null && this.getRemoteUser() != null && this.getAuthType() != null) {
            return true;
        }
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this, (ServletResponse)response));
        }
        if (this._authentication instanceof Authentication.Deferred) {
            response.sendError(401);
        }
        if (!(this._authentication instanceof Authentication.ResponseSent)) {
            return false;
        }
        throw new ServletException("Authentication failed");
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.getParts();
        return this._multiParts.getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        String contentType = this.getContentType();
        if (contentType == null || !MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpField.getValueParameters((String)contentType, null))) {
            throw new ServletException("Unsupported Content-Type [" + contentType + "], expected [multipart/form-data]");
        }
        return this.getParts(null);
    }

    private Collection<Part> getParts(Fields params) throws IOException {
        if (this._multiParts == null) {
            Collection<Part> parts;
            Object multipart;
            if (this._crossContextDispatchSupported && (multipart = this._coreRequest.getAttribute(MultiPart.Parser.class.getName())) instanceof MultiPart.Parser) {
                MultiPart.Parser multiPartParser;
                this._multiParts = multiPartParser = (MultiPart.Parser)multipart;
                return this._multiParts.getParts();
            }
            MultipartConfigElement config = (MultipartConfigElement)this.getAttribute("org.eclipse.jetty.multipartConfig");
            if (config == null) {
                throw new IllegalStateException("No multipart config for servlet");
            }
            int maxFormContentSize = 200000;
            int maxFormKeys = 1000;
            if (this._context != null) {
                ContextHandler contextHandler = this._context.getContextHandler();
                maxFormContentSize = contextHandler.getMaxFormContentSize();
                maxFormKeys = contextHandler.getMaxFormKeys();
            } else {
                if ((maxFormContentSize = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", maxFormContentSize)) < 0) {
                    maxFormContentSize = 200000;
                }
                if ((maxFormKeys = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormKeys", maxFormKeys)) < 0) {
                    maxFormKeys = 1000;
                }
            }
            MultiPartCompliance multiPartCompliance = this.getHttpChannel().getHttpConfiguration().getMultiPartCompliance();
            this._multiParts = this.newMultiParts(multiPartCompliance, config, maxFormKeys);
            try {
                parts = this._multiParts.getParts();
            }
            catch (IOException | RuntimeException e) {
                HttpException.throwIfHttpException((Throwable)e);
                throw new BadMessageException("Unable to parse form content", (Throwable)e);
            }
            this.multipartComplianceCheck();
            String formCharset = null;
            Part charsetPart = this._multiParts.getPart("_charset_");
            if (charsetPart != null) {
                try (InputStream is = charsetPart.getInputStream();){
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    IO.copy((InputStream)is, (OutputStream)os);
                    formCharset = os.toString(StandardCharsets.UTF_8);
                }
            }
            Charset defaultCharset = formCharset != null ? Charset.forName(formCharset) : (this.getCharacterEncoding() != null ? Charset.forName(this.getCharacterEncoding()) : StandardCharsets.UTF_8);
            long formContentSize = 0L;
            ByteArrayOutputStream os = null;
            for (Part p : parts) {
                if (p.getSubmittedFileName() != null) continue;
                formContentSize = Math.addExact(formContentSize, p.getSize());
                if (maxFormContentSize >= 0 && formContentSize > (long)maxFormContentSize) {
                    throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
                }
                String charset = null;
                if (p.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType((String)p.getContentType());
                }
                try (InputStream is = p.getInputStream();){
                    if (os == null) {
                        os = new ByteArrayOutputStream();
                    }
                    IO.copy((InputStream)is, os);
                    String content = os.toString(charset == null ? defaultCharset : Charset.forName(charset));
                    if (this._contentParameters == null) {
                        this._contentParameters = params == null ? new Fields(true) : params;
                    }
                    this._contentParameters.add(p.getName(), content);
                }
                os.reset();
            }
            if (this._crossContextDispatchSupported) {
                this._coreRequest.setAttribute(MultiPart.Parser.class.getName(), this._multiParts);
            }
        }
        return this._multiParts.getParts();
    }

    private void multipartComplianceCheck() {
        ComplianceViolation.Listener complianceViolationListener = org.eclipse.jetty.server.HttpChannel.from((org.eclipse.jetty.server.Request)this.getCoreRequest()).getComplianceViolationListener();
        List<ComplianceViolation.Event> nonComplianceWarnings = this._multiParts.getNonComplianceWarnings();
        for (ComplianceViolation.Event nc : nonComplianceWarnings) {
            MultiPartCompliance.Violation violation;
            MultiPartCompliance multiPartCompliance;
            ComplianceViolation.Mode mode = nc.mode();
            if (!(mode instanceof MultiPartCompliance) || ComplianceUtils.allows((ComplianceViolation.Mode)(multiPartCompliance = (MultiPartCompliance)mode), (ComplianceViolation)(violation = (MultiPartCompliance.Violation)nc.violation()), (ComplianceViolation.Listener)complianceViolationListener)) continue;
            throw new HttpException.RuntimeException(400, nc.details());
        }
    }

    private MultiPart.Parser newMultiParts(MultiPartCompliance multiPartCompliance, MultipartConfigElement config, int maxParts) throws IOException {
        File contextTmpDir = this._context != null ? (File)this._context.getAttribute("jakarta.servlet.context.tempdir") : null;
        return MultiPart.newFormDataParser(multiPartCompliance, (InputStream)this.getInputStream(), this.getContentType(), config, contextTmpDir, maxParts);
    }

    public void login(String username, String password) throws ServletException {
        Authentication auth;
        if (this._authentication instanceof Authentication.LoginAuthentication) {
            auth = ((Authentication.LoginAuthentication)this._authentication).login(username, password, (ServletRequest)this);
            if (auth == null) {
                throw new Authentication.Failed("Authentication failed for username '" + username + "'");
            }
        } else {
            throw new Authentication.Failed("Authenticated failed for username '" + username + "'. Already authenticated as " + String.valueOf(this._authentication));
        }
        this._authentication = auth;
    }

    public void logout() throws ServletException {
        if (this._authentication instanceof Authentication.LogoutAuthentication) {
            this._authentication = ((Authentication.LogoutAuthentication)this._authentication).logout((ServletRequest)this);
        }
    }

    public void mergeQueryParameters(String oldQuery, String newQuery) {
        Fields mergedQueryParams;
        Fields oldQueryParams;
        Fields newQueryParams = null;
        if (newQuery != null) {
            newQueryParams = new Fields(true);
            try {
                UrlEncoded.decodeTo((String)newQuery, (arg_0, arg_1) -> ((Fields)newQueryParams).add(arg_0, arg_1), (Charset)UrlEncoded.ENCODING);
            }
            catch (Throwable th) {
                HttpException.throwIfHttpException((Throwable)th);
                throw new BadMessageException("Bad query encoding", th);
            }
        }
        if ((oldQueryParams = this._queryParameters) == null && oldQuery != null) {
            oldQueryParams = new Fields(true);
            try {
                UrlEncoded.decodeTo((String)oldQuery, (arg_0, arg_1) -> ((Fields)oldQueryParams).add(arg_0, arg_1), (Charset)this.getQueryCharset());
            }
            catch (Throwable th) {
                this._queryParameters = BAD_PARAMS;
                HttpException.throwIfHttpException((Throwable)th);
                throw new BadMessageException("Bad query encoding", th);
            }
        }
        if (newQueryParams == null || newQueryParams.getSize() == 0) {
            mergedQueryParams = oldQueryParams == null ? NO_PARAMS : oldQueryParams;
        } else if (oldQueryParams == null || oldQueryParams.getSize() == 0) {
            mergedQueryParams = newQueryParams;
        } else {
            mergedQueryParams = new Fields(newQueryParams);
            mergedQueryParams.addAll(oldQueryParams);
        }
        this.setQueryFields(mergedQueryParams);
        this.resetParameters();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new ServletException("Not implemented");
    }

    public void setServletPathMapping(ServletPathMapping servletPathMapping) {
        String crossContextDispatchType;
        if (this._crossContextDispatchSupported && this._dispatcherType == DispatcherType.REQUEST && this._servletPathMapping == null && (crossContextDispatchType = this._coreRequest.getContext().getCrossContextDispatchType((org.eclipse.jetty.server.Request)this._coreRequest)) != null) {
            this._dispatcherType = DispatcherType.valueOf((String)crossContextDispatchType);
            if (this._dispatcherType == DispatcherType.INCLUDE) {
                Object attribute = this._coreRequest.getAttribute("org.eclipse.jetty.dispatch.originalServletMapping");
                ServletPathMapping originalMapping = ServletPathMapping.from(attribute);
                if (originalMapping != attribute) {
                    this._coreRequest.setAttribute("org.eclipse.jetty.dispatch.originalServletMapping", originalMapping);
                }
                this._coreRequest.setAttribute("jakarta.servlet.include.mapping", servletPathMapping);
                this._coreRequest.setAttribute("jakarta.servlet.include.servlet_path", servletPathMapping.getServletPath());
                this._coreRequest.setAttribute("jakarta.servlet.include.path_info", servletPathMapping.getPathInfo());
                this._coreRequest.setAttribute("jakarta.servlet.include.context_path", this.getContext().getContextPath());
                this._coreRequest.setAttribute("jakarta.servlet.include.query_string", this.getHttpURI().getQuery());
            }
        }
        this._servletPathMapping = servletPathMapping;
    }

    public ServletPathMapping getServletPathMapping() {
        return this._servletPathMapping;
    }

    ServletPathMapping findServletPathMapping() {
        Dispatcher.IncludeAttributes include;
        ServletPathMapping mapping = this._dispatcherType == DispatcherType.INCLUDE ? (this._crossContextDispatchSupported && DispatcherType.INCLUDE.toString().equals(this._coreRequest.getContext().getCrossContextDispatchType((org.eclipse.jetty.server.Request)this._coreRequest)) ? (ServletPathMapping)this._coreRequest.getAttribute("org.eclipse.jetty.dispatch.originalServletMapping") : ((include = (Dispatcher.IncludeAttributes)Attributes.unwrap((Attributes)this._attributes, Dispatcher.IncludeAttributes.class)) == null ? this._servletPathMapping : include.getSourceMapping())) : this._servletPathMapping;
        return mapping;
    }

    public HttpServletMapping getHttpServletMapping() {
        ServletPathMapping async;
        if (this._dispatcherType == DispatcherType.ASYNC && (async = (ServletPathMapping)this.getAttribute("jakarta.servlet.async.mapping")) != null && "/DispatchServlet".equals(async.getServletPath())) {
            return async;
        }
        return this.findServletPathMapping();
    }
}

