/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.jetty.ee9.maven.plugin.JettyEmbedder;
import org.eclipse.jetty.ee9.maven.plugin.JettyForker;
import org.eclipse.jetty.ee9.maven.plugin.JettyHomeForker;
import org.eclipse.jetty.ee9.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.maven.MavenProjectHelper;
import org.eclipse.jetty.maven.MavenServerConnector;
import org.eclipse.jetty.maven.PluginLog;
import org.eclipse.jetty.maven.ScanTargetPattern;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;

public abstract class AbstractWebAppMojo
extends AbstractMojo {
    public static final String JETTY_HOME_GROUPID = "org.eclipse.jetty";
    public static final String JETTY_HOME_ARTIFACTID = "jetty-home";
    public static final String FAKE_WEBAPP = "webapp-synth";
    @Parameter(defaultValue="10")
    protected int maxChildStartChecks;
    @Parameter(defaultValue="200")
    protected long maxChildStartCheckMs;
    @Parameter(defaultValue="false")
    protected boolean useProvidedScope;
    @Parameter
    protected String[] excludedGoals;
    @Parameter
    protected MavenWebAppContext webApp;
    @Parameter(property="jetty.skip", defaultValue="false")
    protected boolean skip;
    @Parameter
    protected String contextXml;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.artifacts}", readonly=true)
    protected Set<Artifact> projectArtifacts;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    protected MojoExecution execution;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="false")
    protected boolean useTestScope;
    @Parameter
    protected List<ScanTargetPattern> scanTargetPatterns;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    protected File target;
    @Parameter
    protected List<File> jettyXmls;
    @Parameter
    protected Map<String, String> jettyProperties;
    @Parameter(property="jetty.systemPropertiesFile")
    protected File systemPropertiesFile;
    @Parameter
    protected Map<String, String> systemProperties;
    @Parameter(property="jetty.deployMode", defaultValue="EMBED")
    protected DeploymentMode deployMode;
    @Parameter
    protected List<ContextHandler> contextHandlers;
    @Parameter
    protected List<LoginService> loginServices;
    @Parameter
    protected RequestLog requestLog;
    @Parameter
    protected MavenServerConnector httpConnector;
    @Parameter
    protected Server server;
    @Parameter
    protected Map<String, String> env = new HashMap<String, String>();
    @Parameter(property="jetty.jvmArgs")
    protected String jvmArgs;
    @Parameter
    protected int stopPort;
    @Parameter
    protected String stopKey;
    @Parameter
    protected File jettyHome;
    @Parameter
    public File jettyHomeZip;
    @Parameter
    protected File jettyBase;
    @Parameter
    protected String[] modules;
    @Parameter(property="jetty.options")
    protected String jettyOptions;
    @Parameter(defaultValue="${project.build.directory}/fork-web.xml")
    protected File forkWebXml;
    protected MavenProjectHelper mavenProjectHelper;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter
    protected List<String> supportedPackagings = Collections.singletonList("war");
    protected List<Artifact> warArtifacts;
    protected Resource originalBaseResource;
    protected List<File> providedJars;
    protected Map<String, String> mergedSystemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isPackagingSupported()) {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping Jetty start: jetty.skip==true");
                return;
            }
            if (this.isExcludedGoal(this.execution.getMojoDescriptor().getGoal())) {
                this.getLog().info((CharSequence)("The goal \"" + this.execution.getMojoDescriptor().getFullGoalName() + "\" is unavailable for this web app because of an <excludedGoal> configuration."));
                return;
            }
            this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.getProjectName()));
            this.mavenProjectHelper = new MavenProjectHelper(this.project, this.repositorySystem, this.remoteRepositories, this.session);
            this.mergedSystemProperties = this.mergeSystemProperties();
            this.configureSystemProperties();
            this.augmentPluginClasspath();
            PluginLog.setLog((Log)this.getLog());
            this.verifyPomConfiguration();
            this.startJetty();
        } else {
            this.getLog().info((CharSequence)("Packaging type [" + this.project.getPackaging() + "] is unsupported"));
        }
    }

    protected void startJetty() throws MojoExecutionException, MojoFailureException {
        try {
            this.configureWebApp();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Webapp config failure", e);
        }
        switch (this.deployMode.ordinal()) {
            case 0: {
                this.startJettyEmbedded();
                break;
            }
            case 1: {
                this.startJettyForked();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.deployMode != DeploymentMode.EXTERNAL) {
                    this.getLog().warn((CharSequence)(String.valueOf((Object)this.deployMode) + " mode is deprecated, use mode EXTERNAL"));
                }
                this.startJettyHome();
                break;
            }
            default: {
                throw new MojoExecutionException("Unrecognized runType=" + String.valueOf((Object)this.deployMode));
            }
        }
    }

    protected abstract void startJettyEmbedded() throws MojoExecutionException;

    protected abstract void startJettyForked() throws MojoExecutionException;

    protected abstract void startJettyHome() throws MojoExecutionException;

    protected JettyEmbedder newJettyEmbedder() throws Exception {
        JettyEmbedder jetty = new JettyEmbedder();
        jetty.setStopKey(this.stopKey);
        jetty.setStopPort(this.stopPort);
        jetty.setServer(this.server);
        jetty.setContextHandlers(this.contextHandlers);
        jetty.setRequestLog(this.requestLog);
        jetty.setJettyXmlFiles(this.jettyXmls);
        jetty.setHttpConnector(this.httpConnector);
        jetty.setJettyProperties(this.jettyProperties);
        jetty.setLoginServices(this.loginServices);
        jetty.setContextXml(this.contextXml);
        jetty.setWebApp(this.webApp);
        return jetty;
    }

    protected JettyForker newJettyForker() throws Exception {
        JettyForker jetty = new JettyForker();
        jetty.setServer(this.server);
        jetty.setWorkDir(this.project.getBasedir());
        jetty.setStopKey(this.stopKey);
        jetty.setStopPort(this.stopPort);
        jetty.setEnv(this.env);
        jetty.setJvmArgs(this.jvmArgs);
        jetty.setSystemProperties(this.mergedSystemProperties);
        jetty.setContainerClassPath(this.getContainerClassPath());
        jetty.setJettyXmlFiles(this.jettyXmls);
        jetty.setJettyProperties(this.jettyProperties);
        jetty.setForkWebXml(this.forkWebXml);
        jetty.setContextXml(this.contextXml);
        jetty.setWebAppPropsFile(new File(this.target, "webApp.props"));
        Random random = new Random();
        String token = Long.toString(random.nextLong() ^ System.currentTimeMillis(), 36).toUpperCase(Locale.ENGLISH);
        jetty.setTokenFile(this.target.toPath().resolve(token + ".txt").toFile());
        jetty.setWebApp(this.webApp);
        return jetty;
    }

    protected JettyHomeForker newJettyHomeForker() throws Exception {
        JettyHomeForker jetty = new JettyHomeForker();
        jetty.setStopKey(this.stopKey);
        jetty.setStopPort(this.stopPort);
        jetty.setEnv(this.env);
        jetty.setJvmArgs(this.jvmArgs);
        jetty.setJettyOptions(this.jettyOptions);
        jetty.setJettyXmlFiles(this.jettyXmls);
        jetty.setJettyProperties(this.jettyProperties);
        jetty.setModules(this.modules);
        jetty.setSystemProperties(this.mergedSystemProperties);
        Random random = new Random();
        String token = Long.toString(random.nextLong() ^ System.currentTimeMillis(), 36).toUpperCase(Locale.ENGLISH);
        jetty.setTokenFile(this.target.toPath().resolve(token + ".txt").toFile());
        ArrayList<File> libExtJars = new ArrayList<File>();
        List pdeps = this.plugin.getPlugin().getDependencies();
        if (pdeps != null && !pdeps.isEmpty()) {
            boolean warned = false;
            for (Dependency d : pdeps) {
                if (d.getGroupId().equalsIgnoreCase(JETTY_HOME_GROUPID)) {
                    if (warned) continue;
                    this.getLog().warn((CharSequence)"Jetty jars detected in <pluginDependencies>: use <modules> in <configuration> parameter instead to select appropriate jetty modules.");
                    warned = true;
                    continue;
                }
                libExtJars.add(this.mavenProjectHelper.resolveArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getType()));
            }
            jetty.setLibExtJarFiles(libExtJars);
        }
        jetty.setWebApp(this.webApp);
        jetty.setContextXml(this.contextXml);
        if (this.jettyHome == null) {
            jetty.setJettyHomeZip(this.jettyHomeZip != null ? this.jettyHomeZip : this.mavenProjectHelper.resolveArtifact(JETTY_HOME_GROUPID, JETTY_HOME_ARTIFACTID, this.plugin.getVersion(), "zip"));
        }
        jetty.setVersion(this.plugin.getVersion());
        jetty.setJettyHome(this.jettyHome);
        jetty.setJettyBase(this.jettyBase);
        jetty.setBaseDir(this.target);
        return jetty;
    }

    protected void verifyPomConfiguration() throws MojoExecutionException {
    }

    protected Map<String, String> mergeSystemProperties() throws MojoExecutionException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.systemPropertiesFile != null) {
            Properties tmp = new Properties();
            try (FileInputStream propFile = new FileInputStream(this.systemPropertiesFile);){
                tmp.load(propFile);
                for (Object k : tmp.keySet()) {
                    properties.put(k.toString(), tmp.get(k).toString());
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Problem applying system properties from file " + this.systemPropertiesFile.getName(), e);
            }
        }
        if (this.systemProperties != null) {
            properties.putAll(this.systemProperties);
        }
        return properties;
    }

    protected void configureSystemProperties() throws MojoExecutionException {
        if (this.mergedSystemProperties != null) {
            for (Map.Entry<String, String> e : this.mergedSystemProperties.entrySet()) {
                if (StringUtil.isEmpty((String)e.getKey()) || StringUtil.isEmpty((String)e.getValue())) continue;
                System.setProperty(e.getKey(), e.getValue());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Set system property " + e.getKey() + "=" + e.getValue()));
            }
        }
    }

    protected void augmentPluginClasspath() throws MojoExecutionException {
        this.providedJars = this.getProvidedJars();
        if (!this.providedJars.isEmpty()) {
            try {
                Object[] urls = new URL[this.providedJars.size()];
                int i = 0;
                for (File providedJar : this.providedJars) {
                    urls[i++] = providedJar.toURI().toURL();
                }
                URLClassLoader loader = new URLClassLoader((URL[])urls, ((Object)((Object)this)).getClass().getClassLoader());
                Thread.currentThread().setContextClassLoader(loader);
                this.getLog().info((CharSequence)("Plugin classpath augmented with <scope>provided</scope> dependencies: " + Arrays.toString(urls)));
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid url", (Exception)e);
            }
        }
    }

    protected List<File> getProvidedJars() throws MojoExecutionException {
        if (this.useProvidedScope) {
            return this.project.getArtifacts().stream().filter(a -> "provided".equals(a.getScope()) && !this.isPluginArtifact((Artifact)a)).map(a -> a.getFile()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected String getContainerClassPath() throws Exception {
        StringBuilder classPath = new StringBuilder();
        for (Artifact obj : this.pluginArtifacts) {
            Artifact artifact = obj;
            if ("jar".equals(artifact.getType())) {
                if (classPath.length() > 0) {
                    classPath.append(File.pathSeparator);
                }
                classPath.append(artifact.getFile().getAbsolutePath());
                continue;
            }
            if (!artifact.getArtifactId().equals(this.plugin.getArtifactId())) continue;
            classPath.append(artifact.getFile().getAbsolutePath());
        }
        if (this.providedJars != null && !this.providedJars.isEmpty()) {
            for (File jar : this.providedJars) {
                classPath.append(File.pathSeparator);
                classPath.append(jar.getAbsolutePath());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided jar: " + String.valueOf(jar)));
            }
        }
        return classPath.toString();
    }

    protected boolean isPluginArtifact(Artifact artifact) {
        if (this.pluginArtifacts == null) {
            return false;
        }
        return this.pluginArtifacts.stream().anyMatch(pa -> pa.getGroupId().equals(artifact.getGroupId()) && pa.getArtifactId().equals(artifact.getArtifactId()));
    }

    protected boolean isExcludedGoal(String goal) {
        if (this.excludedGoals == null || goal == null) {
            return false;
        }
        if ("".equals(goal = goal.trim())) {
            return false;
        }
        boolean excluded = false;
        for (int i = 0; i < this.excludedGoals.length && !excluded; ++i) {
            if (!this.excludedGoals[i].equalsIgnoreCase(goal)) continue;
            excluded = true;
        }
        return excluded;
    }

    protected boolean isPackagingSupported() {
        return this.supportedPackagings.contains(this.project.getPackaging());
    }

    protected String getProjectName() {
        Object projectName = this.project.getName();
        if (StringUtils.isBlank((String)projectName)) {
            projectName = this.project.getGroupId() + ":" + this.project.getArtifactId();
        }
        return projectName;
    }

    protected void configureWebApp() throws Exception {
        Object cp;
        if (this.webApp == null) {
            this.webApp = new MavenWebAppContext();
        }
        if ((cp = this.webApp.getContextPath()) == null || "".equals(cp)) {
            cp = "/" + this.project.getArtifactId();
            this.webApp.setContextPath((String)cp);
        }
        if (this.webApp.getTempDirectory() == null) {
            File target = new File(this.project.getBuild().getDirectory());
            File tmp = new File(target, "tmp");
            if (!tmp.exists() && !tmp.mkdirs()) {
                throw new MojoFailureException("Unable to create temp directory: " + String.valueOf(tmp));
            }
            this.webApp.setTempDirectory(tmp);
        }
        this.getLog().info((CharSequence)("Context path = " + this.webApp.getContextPath()));
        this.getLog().info((CharSequence)("Tmp directory = " + String.valueOf(this.webApp.getTempDirectory() == null ? " determined at runtime" : this.webApp.getTempDirectory())));
    }

    protected File findJettyWebXmlFile(File webInfDir) {
        if (webInfDir == null) {
            return null;
        }
        if (!webInfDir.exists()) {
            return null;
        }
        File f = new File(webInfDir, "jetty-web.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "web-jetty.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    protected File getJettyOutputFile(String name) throws Exception {
        File outputFile = new File(this.target, name);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        outputFile.createNewFile();
        return outputFile;
    }

    protected void configureScanTargetPatterns(Scanner scanner) throws IOException {
        if (this.scanTargetPatterns != null) {
            for (ScanTargetPattern p : this.scanTargetPatterns) {
                IncludeExcludeSet includesExcludes = scanner.addDirectory(p.getDirectory().toPath());
                p.configureIncludesExcludeSet(includesExcludes);
            }
        }
    }

    public static enum DeploymentMode {
        EMBED,
        FORK,
        HOME,
        DISTRO,
        EXTERNAL;

    }
}

