/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.ee8.nested.ResourceService;
import org.eclipse.jetty.ee8.servlet.ServletHandler;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.content.CachingHttpContentFactory;
import org.eclipse.jetty.http.content.FileMappingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.PreCompressedHttpContentFactory;
import org.eclipse.jetty.http.content.ResourceHttpContentFactory;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.http.content.VirtualHttpContentFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServlet
extends HttpServlet
implements ResourceService.WelcomeFactory {
    public static final String CONTEXT_INIT = "org.eclipse.jetty.servlet.Default.";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServlet.class);
    private static final long serialVersionUID = 4930458713846881193L;
    private final ResourceService _resourceService;
    private ServletContext _servletContext;
    private ContextHandler _contextHandler;
    private boolean _welcomeServlets = false;
    private boolean _welcomeExactServlets = false;
    private Resource _baseResource;
    private CachingHttpContentFactory _cachingContentFactory;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private ResourceFactory.Closeable _resourceFactory;
    private Resource _styleSheet;
    private boolean _useFileMappedBuffer = false;
    private String _relativeBaseResource;
    private ServletHandler _servletHandler;

    public DefaultServlet(ResourceService resourceService) {
        this._resourceService = resourceService;
    }

    public DefaultServlet() {
        this(new ResourceService());
    }

    public void init() throws UnavailableException {
        String cc;
        this._servletContext = this.getServletContext();
        this._contextHandler = this.initContextHandler(this._servletContext);
        this._resourceFactory = ResourceFactory.closeable();
        this._mimeTypes = this._contextHandler.getMimeTypes();
        this._welcomes = this._contextHandler.getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.html", "index.jsp"};
        }
        this._resourceService.setAcceptRanges(this.getInitBoolean("acceptRanges", this._resourceService.isAcceptRanges()));
        this._resourceService.setDirAllowed(this.getInitBoolean("dirAllowed", this._resourceService.isDirAllowed()));
        this._resourceService.setRedirectWelcome(this.getInitBoolean("redirectWelcome", this._resourceService.isRedirectWelcome()));
        this._resourceService.setPrecompressedFormats(this.parsePrecompressedFormats(this.getInitParameter("precompressed"), this.getInitBoolean("gzip"), this._resourceService.getPrecompressedFormats()));
        this._resourceService.setPathInfoOnly(this.getInitBoolean("pathInfoOnly", this._resourceService.isPathInfoOnly()));
        this._resourceService.setEtags(this.getInitBoolean("etags", this._resourceService.isEtags()));
        if ("exact".equals(this.getInitParameter("welcomeServlets"))) {
            this._welcomeExactServlets = true;
            this._welcomeServlets = false;
        } else {
            this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        this._relativeBaseResource = this.getInitParameter("relativeBaseResource", "relativeResourceBase");
        String br = this.getInitParameter("baseResource", "resourceBase");
        if (br == null) {
            this._baseResource = this._contextHandler.getBaseResource();
        } else {
            if (this._relativeBaseResource != null) {
                throw new UnavailableException("baseResource & relativeBaseResource");
            }
            try {
                this._baseResource = this._contextHandler.newResource(br);
            }
            catch (Exception e) {
                LOG.warn("Unable to create baseResource from {}", (Object)br, (Object)e);
                throw new UnavailableException(e.toString());
            }
        }
        String stylesheet = this.getInitParameter("stylesheet");
        try {
            if (stylesheet != null) {
                this._styleSheet = this._resourceFactory.newResource(stylesheet);
                if (Resources.missing((Resource)this._styleSheet)) {
                    LOG.warn("Stylesheet {} does not exist", (Object)stylesheet);
                    this._styleSheet = null;
                }
            }
            if (this._styleSheet == null) {
                this._styleSheet = this._contextHandler.getServer().getDefaultStyleSheet();
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to use stylesheet: {}", (Object)stylesheet, (Object)e);
            }
            LOG.warn("Unable to use stylesheet: {} - {}", (Object)stylesheet, (Object)e.toString());
        }
        int encodingHeaderCacheSize = this.getInitInt("encodingHeaderCacheSize", -1);
        if (encodingHeaderCacheSize >= 0) {
            this._resourceService.setEncodingCacheSize(encodingHeaderCacheSize);
        }
        if ((cc = this.getInitParameter("cacheControl")) != null) {
            this._resourceService.setCacheControl((HttpField)new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, cc));
        }
        if (this._resourceService.getHttpContentFactory() == null) {
            Object contentFactory = (HttpContent.Factory)this.getServletContext().getAttribute(HttpContent.Factory.class.getName());
            if (contentFactory == null) {
                long cacheValidationTime;
                ByteBufferPool.Sized bufferPool = new ByteBufferPool.Sized(DefaultServlet.getByteBufferPool(this._contextHandler), this.getInitBoolean("useDirectByteBuffers", true), this.getInitInt("byteBufferSize", 32768));
                contentFactory = new ResourceHttpContentFactory(this._baseResource, this._mimeTypes, bufferPool){

                    protected Resource resolve(String pathInContext) {
                        return DefaultServlet.this.resolve(pathInContext);
                    }
                };
                if (this._useFileMappedBuffer) {
                    contentFactory = new FileMappingHttpContentFactory(contentFactory);
                }
                contentFactory = new VirtualHttpContentFactory(contentFactory, this._styleSheet, "text/css", bufferPool);
                contentFactory = new PreCompressedHttpContentFactory(contentFactory, this._resourceService.getPrecompressedFormats());
                int maxCacheSize = this.getInitInt("maxCacheSize", -2);
                int maxCachedFileSize = this.getInitInt("maxCachedFileSize", -2);
                int maxCachedFiles = this.getInitInt("maxCachedFiles", -2);
                long l = cacheValidationTime = this.getInitParameter("cacheValidationTime") != null ? Long.parseLong(this.getInitParameter("cacheValidationTime")) : -2L;
                if (maxCachedFiles != -2 || maxCacheSize != -2 || maxCachedFileSize != -2 || cacheValidationTime != -2L) {
                    this._cachingContentFactory = new ValidatingCachingHttpContentFactory(contentFactory, cacheValidationTime > -2L ? cacheValidationTime : Duration.ofSeconds(1L).toMillis(), bufferPool);
                    contentFactory = this._cachingContentFactory;
                    if (maxCacheSize >= 0) {
                        this._cachingContentFactory.setMaxCacheSize((long)maxCacheSize);
                    }
                    if (maxCachedFileSize >= -1) {
                        this._cachingContentFactory.setMaxCachedFileSize(maxCachedFileSize);
                    }
                    if (maxCachedFiles >= -1) {
                        this._cachingContentFactory.setMaxCachedFiles(maxCachedFiles);
                    }
                }
            }
            this._resourceService.setHttpContentFactory(contentFactory);
        }
        this._resourceService.setWelcomeFactory((ResourceService.WelcomeFactory)this);
        ArrayList<Object> gzipEquivalentFileExtensions = new ArrayList<Object>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                gzipEquivalentFileExtensions.add(s.charAt(0) == '.' ? s : "." + s);
            }
        } else {
            gzipEquivalentFileExtensions.add(".svgz");
        }
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
        this._servletHandler = (ServletHandler)this._contextHandler.getChildHandlerByClass(ServletHandler.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("resource base = {}", (Object)this._baseResource);
        }
    }

    private static ByteBufferPool getByteBufferPool(ContextHandler contextHandler) {
        if (contextHandler == null) {
            return ByteBufferPool.NON_POOLING;
        }
        Server server = contextHandler.getServer();
        if (server == null) {
            return ByteBufferPool.NON_POOLING;
        }
        return server.getByteBufferPool();
    }

    private String getInitParameter(String name, String ... deprecated) {
        String value = this.getInitParameter(name);
        if (value != null) {
            return value;
        }
        for (String d : deprecated) {
            value = this.getInitParameter(d);
            if (value == null) continue;
            LOG.warn("Deprecated {} used instead of {}", (Object)d, (Object)name);
            return value;
        }
        return null;
    }

    private CompressedContentFormat[] parsePrecompressedFormats(String precompressed, Boolean gzip, CompressedContentFormat[] dft) {
        if (precompressed == null && gzip == null) {
            return dft;
        }
        ArrayList<CompressedContentFormat> ret = new ArrayList<CompressedContentFormat>();
        if (precompressed != null && precompressed.indexOf(61) > 0) {
            for (String pair : precompressed.split(",")) {
                String[] setting = pair.split("=");
                String encoding = setting[0].trim();
                String extension = setting[1].trim();
                ret.add(new CompressedContentFormat(encoding, extension));
                if (gzip != Boolean.TRUE || ret.contains(CompressedContentFormat.GZIP)) continue;
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (precompressed != null) {
            if (Boolean.parseBoolean(precompressed)) {
                ret.add(CompressedContentFormat.BR);
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (gzip == Boolean.TRUE) {
            ret.add(CompressedContentFormat.GZIP);
        }
        return ret.toArray(new CompressedContentFormat[ret.size()]);
    }

    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler.APIContext scontext = ContextHandler.getCurrentContext();
        if (scontext == null) {
            if (servletContext instanceof ContextHandler.APIContext) {
                return ((ContextHandler.APIContext)servletContext).getContextHandler();
            }
            throw new IllegalArgumentException("The servletContext " + String.valueOf(servletContext) + " " + servletContext.getClass().getName() + " is not " + ContextHandler.APIContext.class.getName());
        }
        return ContextHandler.getCurrentContext().getContextHandler();
    }

    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter(CONTEXT_INIT + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    private Boolean getInitBoolean(String name) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private boolean getInitBoolean(String name, boolean dft) {
        return Optional.ofNullable(this.getInitBoolean(name)).orElse(dft);
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = this.getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    protected Resource resolve(String subUriPath) {
        subUriPath = URIUtil.encodePath((String)subUriPath);
        Resource r = null;
        if (this._relativeBaseResource != null) {
            subUriPath = URIUtil.addPaths((String)this._relativeBaseResource, (String)subUriPath);
        }
        try {
            if (this._baseResource != null) {
                r = this._baseResource.resolve(subUriPath);
            } else if (this._servletContext instanceof ContextHandler.APIContext) {
                r = this._contextHandler.getResource(subUriPath);
            } else {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource {}={}", (Object)subUriPath, (Object)r);
            }
        }
        catch (IOException e) {
            LOG.trace("IGNORED", (Throwable)e);
        }
        if (Resources.missing((Resource)r) && subUriPath.endsWith("/jetty-dir.css")) {
            r = this._styleSheet;
        }
        return r;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this._resourceService.doGet(request, response)) {
            response.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    public void destroy() {
        if (this._cachingContentFactory != null) {
            this._cachingContentFactory.flushCache();
        }
        super.destroy();
        IO.close((Closeable)this._resourceFactory);
    }

    public String getWelcomeFile(String pathInContext) {
        if (this._welcomes == null) {
            return null;
        }
        String welcomeServlet = null;
        for (String s : this._welcomes) {
            ServletHandler.MappedServlet entry;
            String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)s);
            Resource welcome = this.resolve(welcomeInContext);
            if (welcome != null && welcome.exists()) {
                return welcomeInContext;
            }
            if (!this._welcomeServlets && !this._welcomeExactServlets || welcomeServlet != null || (entry = this._servletHandler.getMappedServlet(welcomeInContext)) == null || entry.getServletHolder().getServletInstance() == this || !this._welcomeServlets && (!this._welcomeExactServlets || !entry.getPathSpec().getDeclaration().equals(welcomeInContext))) continue;
            welcomeServlet = welcomeInContext;
        }
        return welcomeServlet;
    }
}

