/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.security.openid;

import java.util.Collection;
import javax.servlet.ServletContext;
import org.eclipse.jetty.ee8.security.Authenticator;
import org.eclipse.jetty.ee8.security.openid.OpenIdAuthenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdLoginService;
import org.eclipse.jetty.server.Server;

public class OpenIdAuthenticatorFactory
implements Authenticator.Factory {
    public Authenticator getAuthenticator(Server server, ServletContext context, Authenticator.AuthConfiguration configuration, IdentityService identityService, LoginService loginService) {
        String auth = configuration.getAuthMethod();
        if ("OPENID".equalsIgnoreCase(auth)) {
            if (loginService instanceof OpenIdLoginService) {
                return new OpenIdAuthenticator(((OpenIdLoginService)loginService).getConfiguration());
            }
            Collection configurations = server.getBeans(OpenIdConfiguration.class);
            if (configurations == null || configurations.isEmpty()) {
                throw new IllegalStateException("No OpenIdConfiguration found");
            }
            if (configurations.size() == 1) {
                return new OpenIdAuthenticator((OpenIdConfiguration)configurations.iterator().next());
            }
            String realmName = configuration.getRealmName();
            OpenIdConfiguration openIdConfiguration = configurations.stream().filter(c -> c.getIssuer().equals(realmName)).findAny().orElseThrow(() -> new IllegalStateException("No OpenIdConfiguration found for realm \"" + realmName + "\""));
            return new OpenIdAuthenticator(openIdConfiguration);
        }
        return null;
    }
}

