/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.cdi;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.ee8.cdi.CdiServletContainerInitializer;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.util.Decorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiSpiDecorator
implements Decorator {
    private static final Logger LOG = LoggerFactory.getLogger(CdiServletContainerInitializer.class);
    public static final String MODE = "CdiSpiDecorator";
    private static final Object NULL_SINGLETON_ARG = null;
    private static final Object[] NULL_ARRAY_ARG = new Object[]{null};
    private final ServletContextHandler _context;
    private final Map<Object, Decorated> _decorated = new HashMap<Object, Decorated>();
    private final Method _current;
    private final Method _getBeanManager;
    private final Method _createAnnotatedType;
    private final Method _createInjectionTarget;
    private final Method _getInjectionTargetFactory;
    private final Method _createCreationalContext;
    private final Method _inject;
    private final Method _dispose;
    private final Method _release;
    private final Set<String> _undecorated = new HashSet<String>(List.of("org.jboss.weld.environment.servlet.Listener", "org.jboss.weld.environment.servlet.EnhancedListener"));

    public CdiSpiDecorator(ServletContextHandler context) throws UnsupportedOperationException {
        this._context = context;
        context.setAttribute("org.eclipse.jetty.cdi", (Object)MODE);
        ClassLoader classLoader = this._context.getClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> cdiClass = classLoader.loadClass("javax.enterprise.inject.spi.CDI");
            Class<?> beanClass = classLoader.loadClass("javax.enterprise.inject.spi.Bean");
            Class<?> beanManagerClass = classLoader.loadClass("javax.enterprise.inject.spi.BeanManager");
            Class<?> annotatedTypeClass = classLoader.loadClass("javax.enterprise.inject.spi.AnnotatedType");
            Class<?> injectionTargetClass = classLoader.loadClass("javax.enterprise.inject.spi.InjectionTarget");
            Class<?> injectionTargetFactoryClass = classLoader.loadClass("javax.enterprise.inject.spi.InjectionTargetFactory");
            Class<?> creationalContextClass = classLoader.loadClass("javax.enterprise.context.spi.CreationalContext");
            Class<?> contextualClass = classLoader.loadClass("javax.enterprise.context.spi.Contextual");
            this._current = cdiClass.getMethod("current", null);
            this._getBeanManager = cdiClass.getMethod("getBeanManager", null);
            this._createAnnotatedType = beanManagerClass.getMethod("createAnnotatedType", Class.class);
            this._getInjectionTargetFactory = beanManagerClass.getMethod("getInjectionTargetFactory", annotatedTypeClass);
            this._createInjectionTarget = injectionTargetFactoryClass.getMethod("createInjectionTarget", beanClass);
            this._createCreationalContext = beanManagerClass.getMethod("createCreationalContext", contextualClass);
            this._inject = injectionTargetClass.getMethod("inject", Object.class, creationalContextClass);
            this._dispose = injectionTargetClass.getMethod("dispose", Object.class);
            this._release = creationalContextClass.getMethod("release", null);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected boolean isDecoratable(Class<?> clazz) {
        if (Object.class == clazz) {
            return true;
        }
        if (this.getUndecoratable().contains(clazz.getName())) {
            return false;
        }
        return this.isDecoratable(clazz.getSuperclass());
    }

    public Set<String> getUndecoratable() {
        return this._undecorated;
    }

    public void setUndecoratable(Set<String> classnames) {
        this._undecorated.clear();
        if (classnames != null) {
            this._undecorated.addAll(classnames);
        }
    }

    public void addUndecoratable(String ... classname) {
        this._undecorated.addAll(Arrays.asList(new String[0]));
    }

    public <T> T decorate(T o) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("decorate {} in {}", o, (Object)this._context);
            }
            if (this.isDecoratable(o.getClass())) {
                this._decorated.put(o, new Decorated(o));
            }
        }
        catch (Throwable th) {
            LOG.warn("Unable to decorate {}", o, (Object)th);
        }
        return o;
    }

    public void destroy(Object o) {
        try {
            Decorated decorated = this._decorated.remove(o);
            if (decorated != null) {
                decorated.destroy(o);
            }
        }
        catch (Throwable th) {
            LOG.warn("Unable to destroy {}", o, (Object)th);
        }
    }

    private class Decorated {
        private final Object _injectionTarget;
        private final Object _creationalContext;

        Decorated(Object o) throws Throwable {
            Object manager = CdiSpiDecorator.this._getBeanManager.invoke(CdiSpiDecorator.this._current.invoke(null, new Object[0]), new Object[0]);
            Object annotatedType = CdiSpiDecorator.this._createAnnotatedType.invoke(manager, o.getClass());
            this._creationalContext = CdiSpiDecorator.this._createCreationalContext.invoke(manager, NULL_SINGLETON_ARG);
            Object injectionTargetFactory = CdiSpiDecorator.this._getInjectionTargetFactory.invoke(manager, annotatedType);
            this._injectionTarget = CdiSpiDecorator.this._createInjectionTarget.invoke(injectionTargetFactory, NULL_ARRAY_ARG);
            CdiSpiDecorator.this._inject.invoke(this._injectionTarget, o, this._creationalContext);
        }

        public void destroy(Object o) throws Throwable {
            CdiSpiDecorator.this._dispose.invoke(this._injectionTarget, o);
            CdiSpiDecorator.this._release.invoke(this._creationalContext, new Object[0]);
        }
    }
}

